/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ide.internal.migration;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecp.ide.internal.migration.Activator;

public final class Resources {
    private static final String VIEW_EXT = "view";

    private Resources() {
    }

    public static Set<IFile> findAllViewFilesInWorkspace(SubMonitor monitor) {
        final LinkedHashSet<IFile> files = new LinkedHashSet<IFile>();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)workspace.getRoot().getProjects().length);
        try {
            workspace.getRoot().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.getFileExtension() != null && resource.getFileExtension().equals(Resources.VIEW_EXT) && resource instanceof IFile) {
                        files.add((IFile)resource);
                    }
                    if (resource instanceof IProject) {
                        subMonitor.worked(1);
                    }
                    return resource.getType() != 1;
                }
            });
        }
        catch (CoreException ex) {
            Activator.log(ex);
        }
        return files;
    }
}

