/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.editor;

import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;

public class EMFUndoRedoActionBarContributor
extends MultiPageEditorActionBarContributor
implements IMenuListener,
IPropertyListener {
    protected IEditorPart activeEditor;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    protected ValidateAction validateAction;
    protected DiagnosticDecorator.LiveValidator.LiveValidationAction liveValidationAction;
    public static final int ADDITIONS_LAST_STYLE = 1;
    protected int style;

    public EMFUndoRedoActionBarContributor() {
    }

    public EMFUndoRedoActionBarContributor(int style) {
        this.style = style;
    }

    public void init(IActionBars actionBars) {
        super.init(actionBars);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.undoAction = this.createUndoAction();
        this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.redoAction = this.createRedoAction();
        this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    protected UndoAction createUndoAction() {
        return new UndoAction();
    }

    protected RedoAction createRedoAction() {
        return new RedoAction();
    }

    protected boolean removeAllReferencesOnDelete() {
        return false;
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
    }

    public void contributeToStatusLine(IStatusLineManager statusLineManager) {
        super.contributeToStatusLine(statusLineManager);
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        super.contributeToToolBar(toolBarManager);
    }

    public void shareGlobalActions(IPage page, IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    @Deprecated
    public void setActiveView(IViewPart part) {
        IActionBars actionBars = part.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        actionBars.updateActionBars();
    }

    public IEditorPart getActiveEditor() {
        return this.activeEditor;
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        if (part != this.activeEditor) {
            if (this.activeEditor != null) {
                this.deactivate();
            }
            if (part instanceof IEditingDomainProvider) {
                this.activeEditor = part;
                this.activate();
            }
        }
    }

    public void setActivePage(IEditorPart part) {
    }

    public void deactivate() {
        ISelectionProvider selectionProvider;
        this.activeEditor.removePropertyListener((IPropertyListener)this);
        this.undoAction.setActiveWorkbenchPart(null);
        this.redoAction.setActiveWorkbenchPart(null);
        if (this.validateAction != null) {
            this.validateAction.setActiveWorkbenchPart(null);
        }
        if (this.liveValidationAction != null) {
            this.liveValidationAction.setActiveWorkbenchPart(null);
        }
        ISelectionProvider iSelectionProvider = selectionProvider = this.activeEditor instanceof ISelectionProvider ? (ISelectionProvider)this.activeEditor : this.activeEditor.getEditorSite().getSelectionProvider();
        if (selectionProvider != null && this.validateAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.validateAction);
        }
    }

    public void activate() {
        ISelectionProvider selectionProvider;
        this.activeEditor.addPropertyListener((IPropertyListener)this);
        this.undoAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        this.redoAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        if (this.validateAction != null) {
            this.validateAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        }
        if (this.liveValidationAction != null) {
            this.liveValidationAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        }
        ISelectionProvider iSelectionProvider = selectionProvider = this.activeEditor instanceof ISelectionProvider ? (ISelectionProvider)this.activeEditor : this.activeEditor.getEditorSite().getSelectionProvider();
        if (selectionProvider != null && this.validateAction != null) {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.validateAction);
        }
        this.update();
    }

    public void update() {
        ISelectionProvider selectionProvider;
        ISelectionProvider iSelectionProvider = selectionProvider = this.activeEditor instanceof ISelectionProvider ? (ISelectionProvider)this.activeEditor : this.activeEditor.getEditorSite().getSelectionProvider();
        if (selectionProvider != null) {
            StructuredSelection structuredSelection;
            ISelection selection = selectionProvider.getSelection();
            Object object = structuredSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
            if (this.validateAction != null) {
                this.validateAction.updateSelection((IStructuredSelection)structuredSelection);
            }
        }
        this.undoAction.update();
        this.redoAction.update();
        if (this.liveValidationAction != null) {
            this.liveValidationAction.update();
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        if ((this.style & 1) == 0) {
            menuManager.add((IContributionItem)new Separator("additions"));
        }
        menuManager.add((IContributionItem)new Separator("edit"));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.undoAction));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.redoAction));
        menuManager.add((IContributionItem)new Separator());
        if ((this.style & 1) != 0) {
            menuManager.add((IContributionItem)new Separator("additions"));
            menuManager.add((IContributionItem)new Separator());
        }
        menuManager.add((IContributionItem)new Separator("additions-end"));
        this.addGlobalActions(menuManager);
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        String key;
        String string = key = (this.style & 1) == 0 ? "additions-end" : "additions";
        if (this.validateAction != null) {
            menuManager.insertBefore(key, (IContributionItem)new ActionContributionItem((IAction)this.validateAction));
        }
        if (this.liveValidationAction != null) {
            menuManager.insertBefore(key, (IContributionItem)new ActionContributionItem((IAction)this.liveValidationAction));
        }
        if (this.validateAction != null) {
            menuManager.insertBefore(key, (IContributionItem)new Separator());
        }
    }

    public void propertyChanged(Object source, int id) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                EMFUndoRedoActionBarContributor.this.update();
            }
        });
    }
}

