/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.databinding.mapping;

import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.databinding.internal.EMFValuePropertyDecorator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecp.view.spi.mappingdmr.model.VMappingDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.internal.core.services.databinding.mapping.EMFMappingValueProperty;
import org.eclipse.emfforms.internal.core.services.databinding.mapping.IllegalMapTypeException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.emf.DomainModelReferenceConverterEMF;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class MappingDomainModelReferenceConverter
implements DomainModelReferenceConverterEMF {
    private EMFFormsDatabindingEMF emfFormsDatabinding;
    private ServiceReference<EMFFormsDatabindingEMF> databindingServiceReference;

    void setEMFFormsDatabinding(EMFFormsDatabindingEMF emfFormsDatabinding) {
        this.emfFormsDatabinding = emfFormsDatabinding;
    }

    void unsetEMFFormsDatabinding() {
        this.emfFormsDatabinding = null;
    }

    protected final void activate(BundleContext bundleContext) {
        this.databindingServiceReference = bundleContext.getServiceReference(EMFFormsDatabindingEMF.class);
        this.setEMFFormsDatabinding((EMFFormsDatabindingEMF)bundleContext.getService(this.databindingServiceReference));
    }

    protected final void deactivate(BundleContext bundleContext) {
        this.unsetEMFFormsDatabinding();
        bundleContext.ungetService(this.databindingServiceReference);
    }

    public double isApplicable(VDomainModelReference domainModelReference) {
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (VMappingDomainModelReference.class.isInstance(domainModelReference)) {
            return 10.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public IEMFValueProperty convertToValueProperty(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        EMFValuePropertyDecorator valueProperty;
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (!VMappingDomainModelReference.class.isInstance(domainModelReference)) {
            throw new IllegalArgumentException("DomainModelReference must be an instance of VMappingDomainModelReference.");
        }
        VMappingDomainModelReference mappingReference = (VMappingDomainModelReference)VMappingDomainModelReference.class.cast(domainModelReference);
        if (mappingReference.getDomainModelEFeature() == null) {
            throw new DatabindingFailedException("The field domainModelEFeature of the given VMappingDomainModelReference must not be null.");
        }
        this.checkMapType(mappingReference.getDomainModelEFeature());
        EList referencePath = mappingReference.getDomainModelEReferencePath();
        EMFValuePropertyDecorator mappingValueProperty = new EMFValuePropertyDecorator((IValueProperty)new EMFMappingValueProperty(this.getEditingDomain(object), mappingReference.getMappedClass(), mappingReference.getDomainModelEFeature()), mappingReference.getDomainModelEFeature());
        if (referencePath.isEmpty()) {
            valueProperty = mappingValueProperty;
        } else {
            IEMFEditValueProperty emfValueProperty = EMFEditProperties.value((EditingDomain)this.getEditingDomain(object), (EStructuralFeature)((EStructuralFeature)referencePath.get(0)));
            int i = 1;
            while (i < referencePath.size()) {
                emfValueProperty = emfValueProperty.value((EStructuralFeature)referencePath.get(i));
                ++i;
            }
            valueProperty = emfValueProperty.value((IEMFValueProperty)mappingValueProperty);
        }
        return valueProperty.value(this.emfFormsDatabinding.getValueProperty(mappingReference.getDomainModelReference(), object));
    }

    public IEMFListProperty convertToListProperty(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        EMFValuePropertyDecorator valueProperty;
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (!VMappingDomainModelReference.class.isInstance(domainModelReference)) {
            throw new IllegalArgumentException("DomainModelReference must be an instance of VMappingDomainModelReference.");
        }
        VMappingDomainModelReference mappingReference = (VMappingDomainModelReference)VMappingDomainModelReference.class.cast(domainModelReference);
        if (mappingReference.getDomainModelEFeature() == null) {
            throw new DatabindingFailedException("The field domainModelEFeature of the given VMappingDomainModelReference must not be null.");
        }
        this.checkMapType(mappingReference.getDomainModelEFeature());
        EList referencePath = mappingReference.getDomainModelEReferencePath();
        EMFValuePropertyDecorator mappingValueProperty = new EMFValuePropertyDecorator((IValueProperty)new EMFMappingValueProperty(this.getEditingDomain(object), mappingReference.getMappedClass(), mappingReference.getDomainModelEFeature()), mappingReference.getDomainModelEFeature());
        if (referencePath.isEmpty()) {
            valueProperty = mappingValueProperty;
        } else {
            IEMFEditValueProperty emfValueProperty = EMFEditProperties.value((EditingDomain)this.getEditingDomain(object), (EStructuralFeature)((EStructuralFeature)referencePath.get(0)));
            int i = 1;
            while (i < referencePath.size()) {
                emfValueProperty = emfValueProperty.value((EStructuralFeature)referencePath.get(i));
                ++i;
            }
            valueProperty = emfValueProperty.value((IEMFValueProperty)mappingValueProperty);
        }
        return valueProperty.list(this.emfFormsDatabinding.getListProperty(mappingReference.getDomainModelReference(), object));
    }

    private void checkMapType(EStructuralFeature structuralFeature) throws IllegalMapTypeException {
        if (!structuralFeature.getEType().getInstanceClassName().equals("java.util.Map$Entry")) {
            throw new IllegalMapTypeException("The VMappingDomainModelReference's domainModelEFeature must reference a map.");
        }
        if (structuralFeature.getLowerBound() != 0 || structuralFeature.getUpperBound() != -1) {
            throw new IllegalMapTypeException("The VMappingDomainModelReference's domainModelEFeature must reference a map.");
        }
        EClass eClass = (EClass)structuralFeature.getEType();
        EStructuralFeature keyFeature = eClass.getEStructuralFeature("key");
        EStructuralFeature valueFeature = eClass.getEStructuralFeature("value");
        if (keyFeature == null || valueFeature == null) {
            throw new IllegalMapTypeException("The VMappingDomainModelReference's domainModelEFeature must reference a map.");
        }
        if (!EReference.class.isInstance(valueFeature)) {
            throw new IllegalMapTypeException("The values of the map referenced by the VMappingDomainModelReference's domainModelEFeature must be referenced EObjects.");
        }
        if (!EReference.class.isInstance(keyFeature)) {
            throw new IllegalMapTypeException("The keys of the map referenced by the VMappingDomainModelReference's domainModelEFeature must be referenced EClasses.");
        }
        if (!EClass.class.isAssignableFrom(((EReference)keyFeature).getEReferenceType().getInstanceClass())) {
            throw new IllegalMapTypeException("The keys of the map referenced by the VMappingDomainModelReference's domainModelEFeature must be referenced EClasses.");
        }
    }

    private EditingDomain getEditingDomain(EObject object) throws DatabindingFailedException {
        return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object);
    }

    public EStructuralFeature.Setting getSetting(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        IEMFValueProperty valueProperty = this.convertToValueProperty(domainModelReference, object);
        IObservableValue observableValue = valueProperty.observe((Object)object);
        EObject eObject = (EObject)((IObserving)IObserving.class.cast(observableValue)).getObserved();
        EStructuralFeature eStructuralFeature = valueProperty.getStructuralFeature();
        if (eStructuralFeature.getEType() == null) {
            throw new DatabindingFailedException(String.format("The eType of the feature %1$s is null.", eStructuralFeature.getName()));
        }
        return ((InternalEObject)InternalEObject.class.cast(eObject)).eSetting(eStructuralFeature);
    }
}

