/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emf2web.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.emf2web.Activator;
import org.eclipse.emf.ecp.emf2web.util.ReferenceHelper;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.core.services.label.NoLabelFoundException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public abstract class AbstractReferenceHelper
implements ReferenceHelper {
    private final EMFFormsDatabinding dataBinding = Activator.getDefault().getEMFFormsDatabinding();
    private static final String DISPLAY_NAME = "_UI_%1$s_%2$s_feature";

    protected EStructuralFeature getEStructuralFeature(VDomainModelReference reference) {
        try {
            IValueProperty valueProperty = this.dataBinding.getValueProperty(reference, null);
            if (valueProperty != null) {
                return (EStructuralFeature)valueProperty.getValueType();
            }
        }
        catch (DatabindingFailedException ex) {
            this.handleDatabindingFailedException(ex);
        }
        return null;
    }

    protected void handleDatabindingFailedException(DatabindingFailedException exception) {
        Activator.getDefault().getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)exception));
    }

    @Override
    public String getLabel(VDomainModelReference reference) {
        String path = this.getEcorePath();
        if (path == null) {
            try {
                BundleContext bundleContext = Activator.getDefault().getBundleContext();
                ServiceReference serviceReference = bundleContext.getServiceReference(EMFFormsLabelProvider.class);
                EMFFormsLabelProvider labelProvider = (EMFFormsLabelProvider)bundleContext.getService(serviceReference);
                IObservableValue observableValue = labelProvider.getDisplayName(reference);
                String result = (String)observableValue.getValue();
                observableValue.dispose();
                bundleContext.ungetService(serviceReference);
                return result;
            }
            catch (NoLabelFoundException ex) {
                Activator.getDefault().getReportService().report(new AbstractReport((Throwable)ex));
                return "";
            }
        }
        String firstPath = path.split("/")[1];
        String editPath = String.valueOf(firstPath) + ".edit/plugin.properties";
        IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember(editPath);
        if (member.exists()) {
            EStructuralFeature feature;
            Properties p;
            block23: {
                File file = member.getLocation().toFile();
                p = new Properties();
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(file);
                    p.load(fis);
                }
                catch (FileNotFoundException ex) {
                    Activator.getDefault().getReportService().report(new AbstractReport((Throwable)ex));
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException ex2) {
                            Activator.getDefault().getReportService().report(new AbstractReport((Throwable)ex2));
                        }
                    }
                    break block23;
                }
                catch (IOException ex) {
                    try {
                        Activator.getDefault().getReportService().report(new AbstractReport((Throwable)ex));
                        break block23;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException ex3) {
                                Activator.getDefault().getReportService().report(new AbstractReport((Throwable)ex3));
                            }
                        }
                    }
                }
                if (fis == null) break block23;
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    Activator.getDefault().getReportService().report(new AbstractReport((Throwable)ex));
                }
            }
            if ((feature = this.getEStructuralFeature(reference)) == null) {
                return null;
            }
            EClass eClass = feature.getEContainingClass();
            String key = String.format(DISPLAY_NAME, eClass.getName(), feature.getName());
            String result = p.getProperty(key);
            if (result == null) {
                return feature.getName();
            }
            return result;
        }
        EStructuralFeature feature = this.getEStructuralFeature(reference);
        return feature.getName();
    }

    protected abstract String getEcorePath();
}

