/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.controls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.EObjectObservableMap;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.edit.internal.swt.controls.ControlMessages;
import org.eclipse.emf.ecp.edit.internal.swt.controls.ECPFocusCellDrawHighlighter;
import org.eclipse.emf.ecp.edit.internal.swt.controls.TableViewerColumnBuilder;
import org.eclipse.emf.ecp.edit.internal.swt.table.TableColumnConfiguration;
import org.eclipse.emf.ecp.edit.internal.swt.table.TableControlConfiguration;
import org.eclipse.emf.ecp.edit.internal.swt.util.CellEditorFactory;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPCellEditor;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.edit.internal.swt.util.SWTControl;
import org.eclipse.emf.ecp.edit.internal.swt.util.SWTRenderingHelper;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.renderer.RenderingResultRow;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapCellLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class TableControl
extends SWTControl {
    private static final String FIXED_COLUMNS = "org.eclipse.rap.rwt.fixedColumns";
    private static final String ICON_ADD = "icons/add.png";
    private TableViewer tableViewer;
    private ComposedAdapterFactory composedAdapterFactory;
    private AdapterFactoryItemDelegator adapterFactoryItemDelegator;
    private Button unsetButton;
    private EClass clazz;
    private TableControlConfiguration tableControlConfiguration;
    private boolean editable = true;
    private Button removeButton;
    private Button addButton;
    private EStructuralFeature.Setting mainSetting;
    private boolean isDisposing;

    private EReference getTableReference() {
        return (EReference)this.getFirstStructuralFeature();
    }

    public final void setTableControlConfiguration(TableControlConfiguration tableControlConfiguration) {
        this.tableControlConfiguration = tableControlConfiguration;
    }

    @Override
    protected Binding bindValue() {
        return null;
    }

    @Override
    public List<RenderingResultRow<Control>> createControls(Composite parent) {
        IItemPropertyDescriptor itemPropertyDescriptor = this.getItemPropertyDescriptor(this.getFirstSetting());
        if (itemPropertyDescriptor == null) {
            return null;
        }
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TableControl.this.dispose();
            }
        });
        List<RenderingResultRow<Control>> list = Collections.singletonList(SWTRenderingHelper.INSTANCE.getResultRowFactory().createRenderingResultRow((Object[])new Control[]{this.createControl(parent)}));
        this.applyValidation(this.getControl().getDiagnostic());
        return list;
    }

    @Override
    public Composite createControl(Composite parent) {
        this.mainSetting = this.getFirstSetting();
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        this.adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)this.composedAdapterFactory);
        this.clazz = this.getTableReference().getEReferenceType();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setBackground(parent.getBackground());
        Composite titleComposite = new Composite(composite, 0);
        titleComposite.setBackground(parent.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)titleComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(titleComposite);
        Label label = new Label(titleComposite, 0);
        label.setBackground(parent.getBackground());
        label.setText(this.getItemPropertyDescriptor(this.mainSetting).getDisplayName(null));
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)label);
        this.validationLabel = new Label(titleComposite, 0);
        this.validationLabel.setBackground(parent.getBackground());
        GridDataFactory.fillDefaults().hint(16, 17).applyTo((Control)this.validationLabel);
        boolean createButtons = true;
        if (this.tableControlConfiguration != null) {
            boolean bl = createButtons = !this.tableControlConfiguration.isAddRemoveDisabled();
        }
        if (createButtons) {
            Composite buttonComposite = new Composite(titleComposite, 0);
            GridDataFactory.fillDefaults().align(0x1000008, 1).grab(true, false).applyTo((Control)buttonComposite);
            int numButtons = 2;
            this.createAddRowButton(this.clazz, buttonComposite);
            this.createRemoveRowButton(this.clazz, buttonComposite);
            if (!this.isEmbedded() && this.getTableReference().isUnsettable()) {
                this.unsetButton = new Button(buttonComposite, 8);
                this.unsetButton.setToolTipText(this.getUnsetButtonTooltip());
                this.unsetButton.setImage(Activator.getImage("icons/delete.png"));
                ++numButtons;
            }
            GridLayoutFactory.fillDefaults().numColumns(numButtons).equalWidth(true).applyTo(buttonComposite);
        }
        Composite controlComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)controlComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(controlComposite);
        this.createContentControl(controlComposite);
        return composite;
    }

    private TableViewer createTableViewer(Composite parent) {
        TableViewer tableViewer = new TableViewer(parent, 68098);
        tableViewer.getTable().setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_table");
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.getTable().setLinesVisible(true);
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(tableViewer, (FocusCellHighlighter)new ECPFocusCellDrawHighlighter((ColumnViewer)tableViewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)tableViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        tableViewer.getTable().setData(FIXED_COLUMNS, (Object)new Integer(1));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
        return tableViewer;
    }

    private void createFixedValidationStatusColumn(TableViewer tableViewer, List<EStructuralFeature> structuralFeatures) {
        TableViewerColumn column = TableViewerColumnBuilder.create().setMoveable(false).setText(ControlMessages.TableControl_ValidationStatusColumn).setWidth(80).build(tableViewer);
        column.setLabelProvider((CellLabelProvider)new ValidationStatusCellLabelProvider(structuralFeatures));
    }

    private EObject getInstanceOf(EClass clazz) {
        return clazz.getEPackage().getEFactoryInstance().create(clazz);
    }

    @Override
    protected void fillControlComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(1, 200).applyTo((Control)composite);
        this.tableViewer = this.createTableViewer(composite);
        ObservableListContentProvider cp = new ObservableListContentProvider();
        EObject tempInstance = this.getInstanceOf(this.clazz);
        ECPTableViewerComparator comparator = new ECPTableViewerComparator();
        this.tableViewer.setComparator((ViewerComparator)comparator);
        int columnNumber = 0;
        Map<EStructuralFeature, Boolean> readOnlyConfig = this.createReadOnlyConfig(this.clazz);
        ArrayList<EStructuralFeature> structuralFeatures = new ArrayList<EStructuralFeature>();
        structuralFeatures.addAll(readOnlyConfig.keySet());
        if (!this.getControl().isReadonly()) {
            this.createFixedValidationStatusColumn(this.tableViewer, structuralFeatures);
        }
        for (EStructuralFeature feature : structuralFeatures) {
            IItemPropertyDescriptor itemPropertyDescriptor = this.adapterFactoryItemDelegator.getPropertyDescriptor((Object)tempInstance, (Object)feature);
            if (itemPropertyDescriptor == null) continue;
            CellEditor cellEditor = this.createCellEditor(tempInstance, feature);
            TableViewerColumn column = TableViewerColumnBuilder.create().setText(itemPropertyDescriptor.getDisplayName(null)).setToolTipText(itemPropertyDescriptor.getDescription(null)).setResizable(true).setMoveable(false).setStyle(this.noStyle()).setData("width", ECPCellEditor.class.isInstance(cellEditor) ? ((ECPCellEditor)ECPCellEditor.class.cast(cellEditor)).getColumnWidthWeight() : 100).build(this.tableViewer);
            column.setLabelProvider((CellLabelProvider)new ECPCellLabelProvider(feature, cellEditor, (IObservableMap)(feature.isMany() ? new EObjectObservableMap(cp.getKnownElements(), feature) : EMFProperties.value((EStructuralFeature)feature).observeDetail(cp.getKnownElements()))));
            column.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(comparator, column.getColumn(), columnNumber));
            if (!TableControl.isReadOnlyFeature(readOnlyConfig, feature)) {
                ECPTableEditingSupport observableSupport = new ECPTableEditingSupport((ColumnViewer)this.tableViewer, cellEditor, feature);
                column.setEditingSupport((EditingSupport)observableSupport);
            }
            ++columnNumber;
        }
        this.tableViewer.setContentProvider((IContentProvider)cp);
        IObservableList list = EMFEditObservables.observeList((EditingDomain)this.getEditingDomain(this.mainSetting), (EObject)this.mainSetting.getEObject(), (EStructuralFeature)this.mainSetting.getEStructuralFeature());
        this.tableViewer.setInput((Object)list);
        TableColumnLayout layout = new TableColumnLayout();
        composite.setLayout((Layout)layout);
        int i = 0;
        while (i < this.tableViewer.getTable().getColumns().length) {
            Integer storedValue = (Integer)this.tableViewer.getTable().getColumns()[i].getData("width");
            layout.setColumnData((Widget)this.tableViewer.getTable().getColumns()[i], (ColumnLayoutData)new ColumnWeightData(storedValue == null ? 50 : storedValue));
            ++i;
        }
    }

    private CellEditor createCellEditor(EObject tempInstance, EStructuralFeature feature) {
        return CellEditorFactory.INSTANCE.getCellEditor(feature, tempInstance, this.tableViewer.getTable(), this.getViewModelContext());
    }

    private static boolean isReadOnlyFeature(Map<EStructuralFeature, Boolean> readOnlyConfig, EStructuralFeature feature) {
        Boolean isReadOnly;
        if (readOnlyConfig != null && (isReadOnly = readOnlyConfig.get(feature)) != null) {
            return isReadOnly;
        }
        return false;
    }

    private Map<EStructuralFeature, Boolean> createReadOnlyConfig(EClass clazz) {
        LinkedHashMap<EStructuralFeature, Boolean> readOnlyConfig = new LinkedHashMap<EStructuralFeature, Boolean>();
        if (this.tableControlConfiguration != null) {
            for (TableColumnConfiguration tcc : this.tableControlConfiguration.getColumns()) {
                readOnlyConfig.put((EStructuralFeature)tcc.getColumnAttribute(), tcc.isReadOnly());
            }
        } else {
            for (EStructuralFeature feature : clazz.getEStructuralFeatures()) {
                readOnlyConfig.put(feature, Boolean.FALSE);
            }
        }
        return readOnlyConfig;
    }

    private int noStyle() {
        return 0;
    }

    @Override
    protected Button getCustomUnsetButton() {
        return this.unsetButton;
    }

    private SelectionAdapter getSelectionAdapter(final ECPTableViewerComparator comparator, final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                comparator.setColumn(index);
                int dir = comparator.getDirection();
                TableControl.this.tableViewer.getTable().setSortDirection(dir);
                TableControl.this.tableViewer.getTable().setSortColumn(column);
                TableControl.this.tableViewer.refresh();
            }
        };
        return selectionAdapter;
    }

    private void createRemoveRowButton(EClass clazz, Composite buttonComposite) {
        this.removeButton = new Button(buttonComposite, 0);
        Image image = Activator.getImage("icons/delete.png");
        this.removeButton.setImage(image);
        this.removeButton.setToolTipText(String.valueOf(ControlMessages.TableControl_RemoveSelected) + clazz.getInstanceClass().getSimpleName());
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)TableControl.this.tableViewer.getSelection();
                if (selection == null || selection.getFirstElement() == null) {
                    return;
                }
                ArrayList<EObject> deletionList = new ArrayList<EObject>();
                Iterator iterator = selection.iterator();
                while (iterator.hasNext()) {
                    deletionList.add((EObject)iterator.next());
                }
                TableControl.this.deleteRowUserConfirmDialog(deletionList);
            }
        });
        List containments = (List)this.mainSetting.get(true);
        if (containments.size() <= this.getTableReference().getLowerBound()) {
            this.removeButton.setEnabled(false);
        }
    }

    protected void deleteRowUserConfirmDialog(final List<EObject> deletionList) {
        MessageDialog dialog = new MessageDialog(this.tableViewer.getTable().getShell(), ControlMessages.TableControl_Delete, null, ControlMessages.TableControl_DeleteAreYouSure, 5, new String[]{JFaceResources.getString((String)"yes"), JFaceResources.getString((String)"no")}, 0);
        new ECPDialogExecutor((Dialog)dialog){

            @Override
            public void handleResult(int codeResult) {
                if (codeResult == 1) {
                    return;
                }
                TableControl.this.deleteRows(deletionList);
                List containments = (List)TableControl.this.mainSetting.get(true);
                if (containments.size() < TableControl.this.getTableReference().getUpperBound()) {
                    TableControl.this.addButton.setEnabled(true);
                }
                if (containments.size() <= TableControl.this.getTableReference().getLowerBound()) {
                    TableControl.this.removeButton.setEnabled(false);
                }
            }
        }.execute();
    }

    protected void deleteRows(List<EObject> deletionList) {
        EditingDomain editingDomain = this.getEditingDomain(this.mainSetting);
        EObject modelElement = this.mainSetting.getEObject();
        editingDomain.getCommandStack().execute(RemoveCommand.create((EditingDomain)editingDomain, (Object)modelElement, (Object)this.getTableReference(), deletionList));
    }

    protected void addRow(EClass clazz) {
        EObject modelElement = this.mainSetting.getEObject();
        EObject instance = clazz.getEPackage().getEFactoryInstance().create(clazz);
        EditingDomain editingDomain = this.getEditingDomain(this.mainSetting);
        editingDomain.getCommandStack().execute(AddCommand.create((EditingDomain)editingDomain, (Object)modelElement, (Object)this.getTableReference(), (Object)instance));
    }

    private void createAddRowButton(final EClass clazz, Composite buttonComposite) {
        this.addButton = new Button(buttonComposite, 0);
        Image image = Activator.getImage(ICON_ADD);
        this.addButton.setImage(image);
        this.addButton.setToolTipText(String.valueOf(ControlMessages.TableControl_AddInstanceOf) + clazz.getInstanceClass().getSimpleName());
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableControl.this.addRow(clazz);
                List containments = (List)TableControl.this.mainSetting.get(true);
                if (TableControl.this.getTableReference().getUpperBound() != -1 && containments.size() >= TableControl.this.getTableReference().getUpperBound()) {
                    TableControl.this.addButton.setEnabled(false);
                }
                if (containments.size() > TableControl.this.getTableReference().getLowerBound()) {
                    TableControl.this.removeButton.setEnabled(true);
                }
            }
        });
        List containments = (List)this.mainSetting.get(true);
        if (this.getTableReference().getUpperBound() != -1 && containments.size() >= this.getTableReference().getUpperBound()) {
            this.addButton.setEnabled(false);
        }
    }

    @Override
    public void dispose() {
        this.isDisposing = true;
        super.dispose();
        this.composedAdapterFactory.dispose();
        this.mainSetting = null;
        this.adapterFactoryItemDelegator = null;
        this.composedAdapterFactory = null;
        this.isDisposing = false;
    }

    protected void applyValidation(VDiagnostic diagnostic) {
        if (this.validationLabel == null || this.validationLabel.isDisposed()) {
            return;
        }
        if (diagnostic != null) {
            Image image = this.getValidationIcon(diagnostic.getHighestSeverity());
            this.validationLabel.setImage(image);
            this.validationLabel.setToolTipText(diagnostic.getMessage());
            for (Object object : (Collection)this.mainSetting.get(true)) {
                this.tableViewer.update(object, null);
            }
        }
    }

    protected String getTableTooltipMessage(Diagnostic diagnostic) {
        return diagnostic.getMessage();
    }

    protected String getRowTooltipMessage(VDiagnostic vDiagnostic) {
        return vDiagnostic.getMessage();
    }

    protected String getCellTooltipMessage(VDiagnostic vDiagnostic) {
        Diagnostic diagnostic;
        if (vDiagnostic == null) {
            return null;
        }
        if (vDiagnostic.getDiagnostics().size() == 0) {
            return vDiagnostic.getMessage();
        }
        Diagnostic reason = diagnostic = (Diagnostic)vDiagnostic.getDiagnostics().get(0);
        if (diagnostic.getChildren() != null && diagnostic.getChildren().size() != 0) {
            reason = (Diagnostic)diagnostic.getChildren().get(0);
        }
        return reason.getMessage();
    }

    @Deprecated
    public void setEditable(boolean isEditable) {
        if (this.addButton != null) {
            this.addButton.setVisible(isEditable);
        }
        if (this.removeButton != null) {
            this.removeButton.setVisible(isEditable);
        }
        this.editable = isEditable;
    }

    @Override
    protected String getUnsetLabelText() {
        return ControlMessages.TableControl_NotSetClickToSet;
    }

    @Override
    protected String getUnsetButtonTooltip() {
        return ControlMessages.TableControl_Unset;
    }

    @Override
    protected Control[] getControlsForTooltip() {
        return new Control[0];
    }

    @Deprecated
    public boolean showLabel() {
        return false;
    }

    public class ECPCellLabelProvider
    extends ObservableMapCellLabelProvider
    implements IColorProvider {
        private final EStructuralFeature feature;
        private final CellEditor cellEditor;

        public ECPCellLabelProvider(EStructuralFeature feature, CellEditor cellEditor, IObservableMap attributeMap) {
            super(attributeMap);
            this.feature = feature;
            this.cellEditor = cellEditor;
        }

        public String getToolTipText(Object element) {
            EObject domainObject = (EObject)element;
            StringBuffer tooltip = new StringBuffer();
            VDiagnostic vDiagnostic = TableControl.this.getControl().getDiagnostic();
            List diagnostics = vDiagnostic.getDiagnostic(domainObject, this.feature);
            for (Diagnostic diagnostic : diagnostics) {
                if (tooltip.length() > 0) {
                    tooltip.append("\n");
                }
                tooltip.append(diagnostic.getMessage());
            }
            return tooltip.toString();
        }

        public void update(ViewerCell cell) {
            EObject element = (EObject)cell.getElement();
            Object value = this.attributeMaps[0].get((Object)element);
            if (ECPCellEditor.class.isInstance(this.cellEditor)) {
                ECPCellEditor ecpCellEditor = (ECPCellEditor)this.cellEditor;
                String text = ecpCellEditor.getFormatedString(value);
                cell.setText(text == null ? "" : text);
            } else {
                cell.setText(value == null ? "" : value.toString());
                cell.getControl().setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_edit_cellEditor_string");
            }
            cell.setBackground(this.getBackground(element));
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            if (TableControl.this.isDisposing) {
                return null;
            }
            VDiagnostic vDiagnostic = TableControl.this.getControl().getDiagnostic();
            List diagnostic = vDiagnostic.getDiagnostic((EObject)element, this.feature);
            return TableControl.this.getValidationBackgroundColor(diagnostic.size() == 0 ? 0 : ((Diagnostic)diagnostic.get(0)).getSeverity());
        }
    }

    private class ECPTableEditingSupport
    extends EditingSupport {
        private final CellEditor cellEditor;
        private final EStructuralFeature cellFeature;
        private EditingState editingState;
        private final ColumnViewerEditorActivationListenerHelper activationListener;

        public ECPTableEditingSupport(ColumnViewer viewer, CellEditor cellEditor, EStructuralFeature feature) {
            super(viewer);
            this.activationListener = new ColumnViewerEditorActivationListenerHelper();
            this.cellEditor = cellEditor;
            this.cellFeature = feature;
        }

        protected boolean canEdit(Object element) {
            if (ECPCellEditor.class.isInstance(this.cellEditor)) {
                ((ECPCellEditor)ECPCellEditor.class.cast(this.cellEditor)).setEditable(TableControl.this.editable);
                return true;
            }
            return TableControl.this.editable;
        }

        protected Object getValue(Object element) {
            return null;
        }

        protected void setValue(Object element, Object value) {
        }

        protected void initializeCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
            IObservableValue target = this.doCreateCellEditorObservable(cellEditor);
            Assert.isNotNull((Object)target, (String)"doCreateCellEditorObservable(...) did not return an observable");
            IObservableValue model = this.doCreateElementObservable(cell.getElement(), cell);
            Assert.isNotNull((Object)model, (String)"doCreateElementObservable(...) did not return an observable");
            Binding binding = this.createBinding(target, model);
            Assert.isNotNull((Object)binding, (String)"createBinding(...) did not return a binding");
            this.editingState = new EditingState(binding, target, model);
            this.getViewer().getColumnViewerEditor().addEditorActivationListener((ColumnViewerEditorActivationListener)this.activationListener);
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected Binding createBinding(IObservableValue target, IObservableValue model) {
            if (ECPCellEditor.class.isInstance(this.cellEditor)) {
                return TableControl.this.getDataBindingContext().bindValue(target, model, ((ECPCellEditor)this.cellEditor).getTargetToModelStrategy(), ((ECPCellEditor)this.cellEditor).getModelToTargetStrategy());
            }
            return TableControl.this.getDataBindingContext().bindValue(target, model);
        }

        protected IObservableValue doCreateElementObservable(Object element, ViewerCell cell) {
            return EMFEditObservables.observeValue((EditingDomain)TableControl.this.getEditingDomain(), (EObject)((EObject)element), (EStructuralFeature)this.cellFeature);
        }

        protected IObservableValue doCreateCellEditorObservable(CellEditor cellEditor) {
            if (ECPCellEditor.class.isInstance(cellEditor)) {
                return ((ECPCellEditor)cellEditor).getValueProperty().observe((Object)cellEditor);
            }
            return SWTObservables.observeText((Control)cellEditor.getControl(), (int)16);
        }

        protected final void saveCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
            this.editingState.binding.updateTargetToModel();
        }

        class ColumnViewerEditorActivationListenerHelper
        extends ColumnViewerEditorActivationListener {
            ColumnViewerEditorActivationListenerHelper() {
            }

            public void afterEditorActivated(ColumnViewerEditorActivationEvent event) {
            }

            public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
                ECPTableEditingSupport.this.editingState.dispose();
                ECPTableEditingSupport.this.editingState = null;
                ECPTableEditingSupport.this.getViewer().getColumnViewerEditor().removeEditorActivationListener((ColumnViewerEditorActivationListener)this);
                ViewerCell focusCell = ECPTableEditingSupport.this.getViewer().getColumnViewerEditor().getFocusCell();
                if (focusCell != null) {
                    ECPTableEditingSupport.this.getViewer().update(focusCell.getElement(), null);
                }
            }

            public void beforeEditorActivated(ColumnViewerEditorActivationEvent event) {
            }

            public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
            }
        }

        class EditingState {
            private final IObservableValue target;
            private final IObservableValue model;
            private final Binding binding;

            EditingState(Binding binding, IObservableValue target, IObservableValue model) {
                this.binding = binding;
                this.target = target;
                this.model = model;
            }

            void dispose() {
                this.binding.dispose();
                this.target.dispose();
                this.model.dispose();
            }
        }
    }

    private class ECPTableViewerComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int NONE = 0;
        private int direction = 0;

        public int getDirection() {
            switch (this.direction) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 128;
                }
                case 2: {
                    return 1024;
                }
            }
            return 0;
        }

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = (this.direction + 1) % 3;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (this.direction == 0) {
                return 0;
            }
            int rc = 0;
            EObject object1 = (EObject)e1;
            EObject object2 = (EObject)e2;
            EStructuralFeature feat1 = (EStructuralFeature)object1.eClass().getEAllStructuralFeatures().get(this.propertyIndex);
            EStructuralFeature feat2 = (EStructuralFeature)object2.eClass().getEAllStructuralFeatures().get(this.propertyIndex);
            Object value1 = object1.eGet(feat1);
            Object value2 = object2.eGet(feat2);
            rc = value1 == null ? 1 : (value2 == null ? -1 : value1.toString().compareTo(value2.toString()));
            if (this.direction == 2) {
                rc = -rc;
            }
            return rc;
        }
    }

    private final class ValidationStatusCellLabelProvider
    extends CellLabelProvider {
        private final List<EStructuralFeature> structuralFeatures;

        private ValidationStatusCellLabelProvider(List<EStructuralFeature> structuralFeatures) {
            this.structuralFeatures = structuralFeatures;
        }

        public void update(ViewerCell cell) {
            Integer mostSevere = 0;
            VDiagnostic vDiagnostic = TableControl.this.getControl().getDiagnostic();
            List diagnostics = vDiagnostic.getDiagnostics((EObject)cell.getElement());
            if (diagnostics.size() != 0) {
                mostSevere = ((Diagnostic)diagnostics.get(0)).getSeverity();
            }
            cell.setImage(TableControl.this.getValidationIcon(mostSevere));
        }

        public String getToolTipText(Object element) {
            StringBuffer tooltip = new StringBuffer();
            VDiagnostic vDiagnostic = TableControl.this.getControl().getDiagnostic();
            List diagnostics = vDiagnostic.getDiagnostics((EObject)element);
            for (Diagnostic diagnostic : diagnostics) {
                if (tooltip.length() > 0) {
                    tooltip.append("\n");
                }
                tooltip.append(diagnostic.getMessage());
            }
            return tooltip.toString();
        }
    }
}

