/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.view.swt;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.common.EMFUtils;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.edit.spi.ReferenceService;
import org.eclipse.emf.ecp.internal.edit.ECPControlHelper;
import org.eclipse.emf.ecp.spi.common.ui.CompositeFactory;
import org.eclipse.emf.ecp.spi.common.ui.SelectModelElementWizardFactory;
import org.eclipse.emf.ecp.spi.common.ui.composites.SelectionComposite;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.internal.swt.Activator;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DefaultReferenceService
implements ReferenceService {
    private EditingDomain editingDomain;

    public void instantiate(ViewModelContext context) {
        this.editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)context.getDomainModel());
    }

    public void dispose() {
    }

    public int getPriority() {
        return 2;
    }

    public void addNewModelElements(EObject eObject, EReference eReference) {
        Collection classes = EMFUtils.getSubClasses((EClass)eReference.getEReferenceType());
        SelectionComposite helper = CompositeFactory.getSelectModelClassComposite(new HashSet(), new HashSet(), (Collection)classes);
        EObject newMEInstance = SelectModelElementWizardFactory.openCreateNewModelElementDialog((SelectionComposite)helper);
        if (newMEInstance == null) {
            return;
        }
        if (eReference.isContainer()) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Operation not permitted for container references!");
            return;
        }
        ECPControlHelper.addModelElementInReference((EObject)eObject, (EObject)newMEInstance, (EReference)eReference, (EditingDomain)this.editingDomain);
        this.openInNewContext(newMEInstance);
    }

    public void openInNewContext(final EObject eObject) {
        Dialog dialog = new Dialog(Display.getDefault().getActiveShell()){

            protected Control createDialogArea(Composite parent) {
                Composite composite = (Composite)super.createDialogArea(parent);
                ViewModelContext vmc = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)ViewProviderHelper.getView((EObject)eObject, null), eObject, new ViewModelService[]{new DefaultReferenceService()});
                try {
                    ECPSWTViewRenderer.INSTANCE.render(composite, vmc);
                }
                catch (ECPRendererException ex) {
                    Activator.log((Exception)((Object)ex));
                }
                return composite;
            }
        };
        new ECPDialogExecutor(dialog){

            public void handleResult(int codeResult) {
            }
        }.execute();
    }

    public void addExistingModelElements(EObject eObject, EReference eReference) {
        Iterator allElements = ItemPropertyDescriptor.getReachableObjectsOfType((EObject)eObject, (EClassifier)eReference.getEType()).iterator();
        LinkedHashSet<EObject> elements = new LinkedHashSet<EObject>();
        while (allElements.hasNext()) {
            elements.add((EObject)allElements.next());
        }
        ECPControlHelper.removeExistingReferences((EObject)eObject, (EReference)eReference, elements);
        Set addedElements = SelectModelElementWizardFactory.openModelElementSelectionDialog(elements, (boolean)eReference.isMany());
        ECPControlHelper.addModelElementsInReference((EObject)eObject, (Set)addedElements, (EReference)eReference, (EditingDomain)this.editingDomain);
    }
}

