/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emfstore.internal.ui.decorator;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.common.cachetree.AbstractCachedTree;
import org.eclipse.emf.ecp.common.cachetree.CachedTreeNode;
import org.eclipse.emf.ecp.common.cachetree.IExcludedObjectsCallback;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.spi.core.InternalProject;

public final class EMFStoreDirtyDecoratorCachedTree
extends AbstractCachedTree<Integer> {
    private static Map<ECPProject, EMFStoreDirtyDecoratorCachedTree> cashedTrees = new HashMap<ECPProject, EMFStoreDirtyDecoratorCachedTree>();

    public static void removeProject(ECPProject project) {
        cashedTrees.remove(project);
    }

    public static EMFStoreDirtyDecoratorCachedTree getInstance(final ECPProject project) {
        if (!cashedTrees.containsKey(project)) {
            cashedTrees.put(project, new EMFStoreDirtyDecoratorCachedTree(new IExcludedObjectsCallback(){

                public boolean isExcluded(Object object) {
                    return ((InternalProject)project).isModelRoot(object);
                }
            }));
        }
        return cashedTrees.get(project);
    }

    private EMFStoreDirtyDecoratorCachedTree(IExcludedObjectsCallback callback) {
        super(callback);
    }

    public Integer getDefaultValue() {
        return 0;
    }

    public CachedTreeNode<Integer> createdCachedTreeNode(Integer t) {
        return new CachedDirtyStateTreeNode(t);
    }

    public Set<EObject> addOperation(EObject eObject) {
        int value = 0;
        CachedTreeNode node = (CachedTreeNode)this.getNodes().get(eObject);
        if (node != null) {
            value = (Integer)node.getOwnValue();
        }
        return this.update(eObject, ++value);
    }

    public Set<EObject> removeOperation(EObject eObject) {
        int value = 0;
        CachedTreeNode node = (CachedTreeNode)this.getNodes().get(eObject);
        if (node != null) {
            value = (Integer)node.getOwnValue();
        }
        return this.update(eObject, Math.max(0, --value));
    }

    public Set<EObject> setOperationCount(EObject eObject, int count) {
        return this.update(eObject, count);
    }

    public int getOwnValue(EObject eObject) {
        int value = 0;
        CachedTreeNode node = (CachedTreeNode)this.getNodes().get(eObject);
        if (node != null) {
            value = (Integer)node.getOwnValue();
        }
        return value;
    }

    public class CachedDirtyStateTreeNode
    extends CachedTreeNode<Integer> {
        public CachedDirtyStateTreeNode(Integer value) {
            super((Object)0);
            this.setChildValue(EMFStoreDirtyDecoratorCachedTree.this.getDefaultValue());
        }

        public void update() {
            this.setChildValue(EMFStoreDirtyDecoratorCachedTree.this.getDefaultValue());
            for (Integer value : this.values()) {
                if (value <= (Integer)this.getChildValue()) continue;
                this.setChildValue(value);
                break;
            }
        }

        public Integer getDisplayValue() {
            return (Integer)this.getChildValue() > 0 || (Integer)this.getOwnValue() > 0 ? 1 : 0;
        }
    }
}

