/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.editor.handler;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.view.editor.controls.Activator;
import org.eclipse.emf.ecp.view.editor.controls.Helper;
import org.eclipse.emf.ecp.view.spi.model.VContainer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;

public final class ControlGenerator {
    private ControlGenerator() {
    }

    public static void addControls(ECPProject project, VContainer compositeToFill, EClass datasegment, Set<EStructuralFeature> features) {
        EClass rootClass = Helper.getRootEClass(project);
        ControlGenerator.addControls(rootClass, (VElement)compositeToFill, features);
    }

    public static void addControls(EClass rootClass, VElement compositeToFill, Set<EStructuralFeature> features) {
        if (!VContainer.class.isInstance(compositeToFill) && !VView.class.isInstance(compositeToFill)) {
            return;
        }
        HashMap<EClass, EReference> childParentReferenceMap = new HashMap<EClass, EReference>();
        Helper.getReferenceMap(rootClass, childParentReferenceMap);
        for (EStructuralFeature feature : features) {
            VControl control = VViewFactory.eINSTANCE.createControl();
            control.setName("Control " + feature.getName());
            control.setReadonly(false);
            VFeaturePathDomainModelReference modelReference = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
            modelReference.setDomainModelEFeature(feature);
            List<EReference> bottomUpPath = Helper.getReferencePath(rootClass, feature.getEContainingClass(), childParentReferenceMap);
            modelReference.getDomainModelEReferencePath().addAll(bottomUpPath);
            control.setDomainModelReference((VDomainModelReference)modelReference);
            if (VContainer.class.isInstance(compositeToFill)) {
                ((VContainer)compositeToFill).getChildren().add((Object)control);
                continue;
            }
            if (!VView.class.isInstance(compositeToFill)) continue;
            ((VView)compositeToFill).getChildren().add((Object)control);
        }
    }

    public static void generateAllControls(VView view) {
        URI uri = EcoreUtil.getURI((EObject)view);
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("*", new XMIResourceFactoryImpl());
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.getResource(uri, true);
        try {
            resource.load(null);
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.view.editor.controls", e.getMessage(), (Throwable)e));
        }
        int rsSize = resSet.getResources().size();
        EcoreUtil.resolveAll((ResourceSet)resSet);
        while (rsSize != resSet.getResources().size()) {
            EcoreUtil.resolveAll((ResourceSet)resSet);
            rsSize = resSet.getResources().size();
        }
        VView vview = (VView)resource.getContents().get(0);
        EClass rootEClass = vview.getRootEClass();
        LinkedHashSet<EStructuralFeature> mySet = new LinkedHashSet<EStructuralFeature>((Collection<EStructuralFeature>)rootEClass.getEAllStructuralFeatures());
        ControlGenerator.addControls(rootEClass, (VElement)((VView)resource.getContents().get(0)), mySet);
        try {
            resource.save(null);
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.view.editor.controls", e.getMessage(), (Throwable)e));
        }
    }
}

