/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.inheritance;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edapt.common.MetamodelUtils;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="imitateSuperType", label="Unfold Superclass", description="In the metamodel, a superclass is removed from a subclass, while all its features are copied into the subclass. In the model, values are changed accordingly.")
public class ImitateSuperType
extends OperationImplementation {
    @EdaptParameter(main=true, description="The subclass")
    public EClass subClass;
    @EdaptParameter(description="The superclass")
    public EClass superClass;

    @EdaptConstraint(restricts="superClass", description="The super class has to be a super type of the sub class")
    public boolean checkSuperClass(EClass superClass) {
        return this.subClass.getESuperTypes().contains((Object)superClass);
    }

    @EdaptConstraint(description="The super class must not be target of a reference")
    public boolean checkSuperClassNoReferenceTarget(Metamodel metamodel) {
        return metamodel.getInverse((EModelElement)this.superClass, EcorePackage.eINSTANCE.getETypedElement_EType()).isEmpty();
    }

    public void initialize(Metamodel metamodel) {
        if (this.superClass == null && !this.subClass.getESuperTypes().isEmpty()) {
            this.superClass = (EClass)this.subClass.getESuperTypes().get(0);
        }
    }

    public void execute(Metamodel metamodel, Model model) {
        EList features = this.superClass.getEStructuralFeatures();
        this.subClass.getESuperTypes().remove((Object)this.superClass);
        this.subClass.getESuperTypes().addAll((Collection)this.superClass.getESuperTypes());
        ArrayList<EStructuralFeature> clones = new ArrayList<EStructuralFeature>();
        for (EStructuralFeature feature : features) {
            EStructuralFeature clone = (EStructuralFeature)MetamodelUtils.copy((EModelElement)feature);
            this.subClass.getEStructuralFeatures().add((Object)clone);
            clones.add(clone);
        }
        for (Instance instance : model.getAllInstances(this.subClass)) {
            int i = 0;
            while (i < features.size()) {
                instance.set((EStructuralFeature)clones.get(i), instance.unset((EStructuralFeature)features.get(i)));
                ++i;
            }
        }
    }
}

