/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.presentation.action;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edapt.history.presentation.AttachMigrationCommand;
import org.eclipse.emf.edapt.history.presentation.action.JavaUIUtils;
import org.eclipse.emf.edapt.history.presentation.action.SubsequentChangesHandler;
import org.eclipse.emf.edapt.history.reconstruction.EcoreForwardReconstructor;
import org.eclipse.emf.edapt.history.reconstruction.IReconstructor;
import org.eclipse.emf.edapt.history.reconstruction.MigrationChangeReconstructor;
import org.eclipse.emf.edapt.spi.history.Change;
import org.eclipse.emf.edapt.spi.history.MigrateableChange;
import org.eclipse.emf.edapt.spi.history.MigrationChange;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachMigrationHandler
extends SubsequentChangesHandler<MigrateableChange> {
    @Override
    protected Object execute(Release release, List<MigrateableChange> changes, EditingDomain domain, ExecutionEvent event) {
        IType element;
        MigrateableChange targetChange;
        MigrateableChange sourceChange = changes.get(0);
        MigrationChangeReconstructor reconstructor = this.reconstruct(sourceChange, targetChange = changes.get(changes.size() - 1));
        if (this.isConsistent(reconstructor) && (element = JavaUIUtils.createCustomMigration((EObject)release)) != null) {
            this.attachMigration(changes, element.getFullyQualifiedName(), domain);
        }
        return null;
    }

    private MigrationChangeReconstructor reconstruct(MigrateableChange sourceChange, MigrateableChange targetChange) {
        EcoreForwardReconstructor ecoreReconstructor = new EcoreForwardReconstructor(sourceChange.eResource().getURI());
        MigrationChangeReconstructor migrationReconstructor = new MigrationChangeReconstructor(sourceChange, targetChange);
        ecoreReconstructor.addReconstructor((IReconstructor)migrationReconstructor);
        ecoreReconstructor.reconstruct((Change)targetChange, false);
        return migrationReconstructor;
    }

    private boolean isConsistent(MigrationChangeReconstructor migrationReconstructor) {
        if (!migrationReconstructor.isConsistent()) {
            return MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Metamodel inconsistent", (String)"The metamodel is inconsistent before or after the changes. Do you really want to attach a migration to them?");
        }
        return true;
    }

    private MigrationChange attachMigration(List<MigrateableChange> changes, String migration, EditingDomain domain) {
        AttachMigrationCommand command = new AttachMigrationCommand(changes, migration);
        domain.getCommandStack().execute((Command)command);
        return command.getMigrationChange();
    }
}

