/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.inheritance;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.common.MetamodelUtils;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="pushFeature", label="Push down Feature", description="In the metamodel, a feature is pushed down to its sub classes. In the model, values are changed accordingly.")
public class PushFeature
extends OperationImplementation {
    @EdaptParameter(main=true, description="The feature to be pushed down")
    public EStructuralFeature feature;

    @EdaptConstraint(restricts="feature", description="If the feature has an opposite, then the super class may only have one sub type.")
    public boolean checkFeature(EStructuralFeature feature, Metamodel metamodel) {
        EClass superClass = feature.getEContainingClass();
        if (feature instanceof EReference) {
            EReference reference = (EReference)feature;
            return reference.getEOpposite() == null || metamodel.getESubTypes(superClass).size() == 1;
        }
        return true;
    }

    public void execute(Metamodel metamodel, Model model) {
        EClass superClass = this.feature.getEContainingClass();
        EList subClasses = metamodel.getESubTypes(superClass);
        boolean first = true;
        for (EClass subClass : subClasses) {
            if (first) {
                EReference reference;
                subClass.getEStructuralFeatures().add((Object)this.feature);
                if (this.feature instanceof EReference && (reference = (EReference)this.feature).getEOpposite() != null) {
                    reference.getEOpposite().setEType((EClassifier)subClass);
                }
            } else {
                EStructuralFeature clone = (EStructuralFeature)MetamodelUtils.copy((EModelElement)this.feature);
                subClass.getEStructuralFeatures().add((Object)clone);
                for (Instance instance : model.getAllInstances(subClass)) {
                    instance.set(clone, instance.unset(this.feature));
                }
            }
            first = false;
        }
        if (MetamodelUtils.isConcrete((EClass)superClass)) {
            for (Instance instance : model.getInstances(superClass)) {
                this.deleteFeatureValue(instance, this.feature);
            }
        }
    }
}

