/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.instantiation.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.edapt.history.instantiation.UndoChangesCommand;
import org.eclipse.emf.edapt.history.presentation.action.SubsequentChangesHandler;
import org.eclipse.emf.edapt.history.recorder.EditingDomainListener;
import org.eclipse.emf.edapt.history.recorder.ui.EcoreEditorDetector;
import org.eclipse.emf.edapt.history.util.DependencyChecker;
import org.eclipse.emf.edapt.spi.history.Change;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndoChangesHandler
extends SubsequentChangesHandler<Change> {
    @Override
    protected Object execute(Release release, List<Change> changes, EditingDomain domain, ExecutionEvent event) {
        EcoreEditor editor = (EcoreEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (DependencyChecker.depends(this.getSubsequentChanges(changes), changes)) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Dependency", (String)"These changes cannot be undone. There are subsequent changes which depend on these changes.");
        } else {
            EcoreEditorDetector detector = EcoreEditorDetector.getInstance();
            EditingDomainListener listener = detector.getListener(editor);
            UndoChangesCommand command = new UndoChangesCommand(changes, listener.getExtent());
            domain.getCommandStack().execute((Command)command);
        }
        return null;
    }

    private List<Change> getSubsequentChanges(List<Change> changes) {
        Change lastChange = changes.get(changes.size() - 1);
        ArrayList<Change> subsequentChanges = new ArrayList<Change>();
        Release release = lastChange.getRelease();
        EList releaseChanges = release.getChanges();
        int i = releaseChanges.indexOf(lastChange) + 1;
        while (i < releaseChanges.size()) {
            subsequentChanges.add((Change)releaseChanges.get(i));
            ++i;
        }
        EList releases = release.getHistory().getReleases();
        int i2 = release.getNumber() + 1;
        while (i2 < releases.size()) {
            subsequentChanges.addAll((Collection<Change>)((Release)releases.get(i2)).getChanges());
            ++i2;
        }
        return subsequentChanges;
    }
}

