/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.instantiation;

import java.util.List;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.command.ChangeCommand;

public class UpdatePackageNamespaceCommand
extends ChangeCommand {
    private final List<EPackage> ePackages;
    private final String toReplace;
    private final String replaceBy;

    public UpdatePackageNamespaceCommand(List<EPackage> ePackages, String toReplace, String replaceBy) {
        super(ePackages);
        this.ePackages = ePackages;
        this.toReplace = toReplace;
        this.replaceBy = replaceBy;
    }

    protected void doExecute() {
        this.updatePackageNamespace(this.ePackages);
    }

    private void updatePackageNamespace(List<EPackage> ePackages) {
        for (EPackage ePackage : ePackages) {
            String nsURI = ePackage.getNsURI();
            String updatedNsURI = nsURI.replace(this.toReplace, this.replaceBy);
            if (!updatedNsURI.equals(nsURI)) {
                ePackage.setNsURI(updatedNsURI);
            }
            this.updatePackageNamespace((List<EPackage>)ePackage.getESubpackages());
        }
    }
}

