/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;
import org.apache.derby.shared.common.error.StandardException;

public abstract class BinaryListOperatorNode
extends ValueNode {
    String methodName;
    String operator;
    ValueNode leftOperand;
    ValueNodeList rightOperandList;

    BinaryListOperatorNode(ValueNode valueNode, ValueNodeList valueNodeList, String string, String string2, ContextManager contextManager) throws SecurityException {
        super(contextManager);
        this.leftOperand = valueNode;
        this.rightOperandList = valueNodeList;
        this.operator = string;
        this.methodName = string2;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, list);
        this.rightOperandList.bindExpression(fromList, subqueryList, list);
        if (this.leftOperand.requiresTypeFromContext()) {
            if (this.rightOperandList.containsAllParameterNodes()) {
                throw StandardException.newException("42X35", this.operator);
            }
            this.leftOperand.setType(this.rightOperandList.getTypeServices());
        }
        if (this.rightOperandList.containsParameterNode()) {
            this.rightOperandList.setParameterDescriptor(this.leftOperand.getTypeServices());
        }
        if (this.leftOperand.getTypeId().userType()) {
            this.leftOperand = this.leftOperand.genSQLJavaSQLTree();
        }
        this.rightOperandList.genSQLJavaSQLTrees();
        this.bindComparisonOperator();
        return this;
    }

    void bindComparisonOperator() throws StandardException {
        this.rightOperandList.comparable(this.leftOperand);
        boolean bl = this.leftOperand.getTypeServices().isNullable() || this.rightOperandList.isNullable();
        this.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, bl));
    }

    @Override
    ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        this.leftOperand = this.leftOperand.preprocess(n, fromList, subqueryList, predicateList);
        this.rightOperandList.preprocess(n, fromList, subqueryList, predicateList);
        return this;
    }

    void setLeftOperand(ValueNode valueNode) {
        this.leftOperand = valueNode;
    }

    ValueNode getLeftOperand() {
        return this.leftOperand;
    }

    void setRightOperandList(ValueNodeList valueNodeList) {
        this.rightOperandList = valueNodeList;
    }

    ValueNodeList getRightOperandList() {
        return this.rightOperandList;
    }

    @Override
    boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        boolean bl2 = this.leftOperand.categorize(jBitSet, bl);
        bl2 = this.rightOperandList.categorize(jBitSet, bl) && bl2;
        return bl2;
    }

    @Override
    ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.leftOperand = this.leftOperand.remapColumnReferencesToExpressions();
        this.rightOperandList.remapColumnReferencesToExpressions();
        return this;
    }

    @Override
    boolean isConstantExpression() {
        return this.leftOperand.isConstantExpression() && this.rightOperandList.isConstantExpression();
    }

    @Override
    boolean constantExpression(PredicateList predicateList) {
        return this.leftOperand.constantExpression(predicateList) && this.rightOperandList.constantExpression(predicateList);
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        int n = this.leftOperand.getOrderableVariantType();
        int n2 = this.rightOperandList.getOrderableVariantType();
        return Math.min(n, n2);
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.leftOperand != null) {
            this.leftOperand = (ValueNode)this.leftOperand.accept(visitor);
        }
        if (this.rightOperandList != null) {
            this.rightOperandList = (ValueNodeList)this.rightOperandList.accept(visitor);
        }
    }

    @Override
    boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (!this.isSameNodeKind(valueNode)) {
            return false;
        }
        BinaryListOperatorNode binaryListOperatorNode = (BinaryListOperatorNode)valueNode;
        if (!this.operator.equals(binaryListOperatorNode.operator) || !this.leftOperand.isEquivalent(binaryListOperatorNode.getLeftOperand())) {
            return false;
        }
        return this.rightOperandList.isEquivalent(binaryListOperatorNode.rightOperandList);
    }
}

