/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.AbstractImmutableList;
import org.jboss.weld.util.collections.ImmutableArrayList;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.collections.ImmutableTinyList;

public abstract class ImmutableList<E>
extends AbstractImmutableList<E> {
    ImmutableList() {
    }

    @SafeVarargs
    public static <T> List<T> of(T ... elements) {
        Preconditions.checkNotNull(elements);
        return ImmutableList.ofInternal(elements);
    }

    public static <T> List<T> copyOf(T[] elements) {
        Preconditions.checkNotNull(elements);
        return ImmutableList.ofInternal((Object[])elements.clone());
    }

    public static <T> List<T> copyOf(Collection<T> source) {
        Preconditions.checkNotNull(source);
        if (source instanceof ImmutableList) {
            return (ImmutableList)source;
        }
        if (source.isEmpty()) {
            return Collections.emptyList();
        }
        return ImmutableList.ofInternal(source.toArray());
    }

    public static <T> List<T> copyOf(Iterable<T> source) {
        Preconditions.checkNotNull(source);
        if (source instanceof Collection) {
            return ImmutableList.copyOf((Collection)source);
        }
        return ImmutableList.builder().addAll(source).build();
    }

    private static <T> List<T> ofInternal(Object[] elements) {
        switch (elements.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return new ImmutableTinyList.Singleton<Object>(elements[0]);
            }
        }
        return new ImmutableArrayList(ImmutableList.checkElementsNotNull(elements));
    }

    private static Object[] checkElementsNotNull(Object[] objects) {
        for (Object object : objects) {
            Preconditions.checkNotNull(object);
        }
        return objects;
    }

    public static <T> ImmutableListCollector<T> collector() {
        return ImmutableListCollector.INSTANCE;
    }

    public static <T> Builder<T> builder() {
        return new BuilderImpl();
    }

    private static class ImmutableListCollector<T>
    implements Collector<T, BuilderImpl<T>, List<T>> {
        private static final ImmutableListCollector<Object> INSTANCE = new ImmutableListCollector();
        private static final Set<Collector.Characteristics> CHARACTERISTICS = ImmutableSet.of(new Collector.Characteristics[0]);

        private ImmutableListCollector() {
        }

        @Override
        public Supplier<BuilderImpl<T>> supplier() {
            return () -> new BuilderImpl();
        }

        @Override
        public BiConsumer<BuilderImpl<T>, T> accumulator() {
            return BuilderImpl::add;
        }

        @Override
        public BinaryOperator<BuilderImpl<T>> combiner() {
            return (builder1, builder2) -> builder1.addAll(builder2);
        }

        @Override
        public Function<BuilderImpl<T>, List<T>> finisher() {
            return BuilderImpl::build;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return CHARACTERISTICS;
        }
    }

    private static class BuilderImpl<T>
    implements Builder<T> {
        private static final int DEFAULT_CAPACITY = 10;
        private List<T> list = new ArrayList<T>(10);

        private BuilderImpl() {
        }

        @Override
        public Builder<T> add(T item) {
            if (item == null) {
                throw new IllegalArgumentException("This collection does not support null values");
            }
            this.list.add(item);
            return this;
        }

        @Override
        public Builder<T> addAll(T ... items) {
            for (T item : items) {
                this.add(item);
            }
            return this;
        }

        @Override
        public Builder<T> addAll(Iterable<? extends T> items) {
            for (T item : items) {
                this.add(item);
            }
            return this;
        }

        @Override
        BuilderImpl<T> addAll(BuilderImpl<T> items) {
            this.addAll((Iterable<? extends T>)items.list);
            return this;
        }

        @Override
        public List<T> build() {
            return ImmutableList.ofInternal(this.list.toArray());
        }
    }

    public static interface Builder<T> {
        public Builder<T> add(T var1);

        public Builder<T> addAll(Iterable<? extends T> var1);

        public Builder<T> addAll(T ... var1);

        public List<T> build();
    }
}

