/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.authenticator;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.web.ha.authenticator.HASessionData;

public class HASingleSignOnEntryMetadata
implements Serializable {
    protected String id = null;
    protected String authType = null;
    protected byte[] principalBytes = null;
    protected Set<HASessionData> sessionDataSet = new HashSet<HASessionData>();
    protected String userName = null;
    protected String realmName = null;
    protected long lastAccessTime;
    protected long maxIdleTime;
    protected long version;

    public HASingleSignOnEntryMetadata() {
    }

    public HASingleSignOnEntryMetadata(String id, long version, byte[] principalBytes, String authType, String userName, String realmName, long lastAccessTime, long maxIdleTime) {
        this.id = id;
        this.version = version;
        this.principalBytes = principalBytes != null ? (byte[])principalBytes.clone() : null;
        this.authType = authType;
        this.userName = userName;
        this.realmName = realmName;
        this.lastAccessTime = lastAccessTime;
        this.maxIdleTime = maxIdleTime;
    }

    public String getId() {
        return this.id;
    }

    public byte[] getPrincipalBytes() {
        return this.principalBytes;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public Set<HASessionData> getHASessionDataSet() {
        return this.sessionDataSet;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public long getVersion() {
        return this.version;
    }

    void setVersion(long version) {
        this.version = version;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    boolean addHASessionData(HASessionData sessionData) {
        return this.sessionDataSet.add(sessionData);
    }

    boolean removeHASessionData(HASessionData sessionData) {
        return this.sessionDataSet.remove(sessionData);
    }

    public String toString() {
        return "HASingleSignOnEntryMetadata{id='" + this.id + "', version=" + this.version + ", authType='" + this.authType + "', sessionDataSet.size=" + this.sessionDataSet.size() + ", userName='" + this.userName + "', realmName='" + this.realmName + "', lastAccessTime=" + this.lastAccessTime + ", maxIdleTime=" + this.maxIdleTime + "}";
    }
}

