/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.util.scope;

import com.sun.jdo.spi.persistence.support.sqlstore.query.util.scope.Definition;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.scope.Nesting;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;

public class SymbolTable {
    protected int actualScope = 0;
    protected Stack nestings = new Stack();
    protected Hashtable symbols = new Hashtable();

    public void enterScope() {
        ++this.actualScope;
        this.nestings.push(new Nesting());
    }

    public void leaveScope() {
        this.forgetNesting((Nesting)this.nestings.pop());
        --this.actualScope;
    }

    public int getActualScope() {
        return this.actualScope;
    }

    public Definition declare(String ident, Definition def) {
        Definition old = (Definition)this.symbols.get(ident);
        def.setScope(this.actualScope);
        if (old == null || old.getScope() < this.actualScope) {
            Nesting nest = (Nesting)this.nestings.peek();
            nest.add(ident, old);
            this.symbols.put(ident, def);
            return null;
        }
        return old;
    }

    public boolean isDeclared(String ident) {
        return this.getDefinition(ident) != null;
    }

    public Definition getDefinition(String ident) {
        return (Definition)this.symbols.get(ident);
    }

    protected void forgetNesting(Nesting nesting) {
        String ident = null;
        Definition hidden = null;
        Iterator idents = nesting.getIdents();
        Iterator hiddenDefs = nesting.getHiddenDefinitions();
        while (idents.hasNext()) {
            ident = (String)idents.next();
            hidden = (Definition)hiddenDefs.next();
            if (hidden == null) {
                this.symbols.remove(ident);
                continue;
            }
            this.symbols.put(ident, hidden);
        }
    }
}

