/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.services.impl.AbstractThreadPoolServiceImpl;
import com.ibm.jbatch.container.util.BatchContainerConstants;
import com.ibm.jbatch.spi.services.IBatchConfig;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BoundedThreadPoolServiceImpl
extends AbstractThreadPoolServiceImpl
implements BatchContainerConstants {
    private static final String sourceClass = BoundedThreadPoolServiceImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private String defaultMaxThreadPoolSize = "5";
    int idleThreadTimeout = 900;
    int maxQueueSize = 4096;
    int minThreadPoolSize = 3;

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        String method = "init";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        String maxThreadPoolSizeStr = batchConfig.getConfigProperties().getProperty("BOUNDED_THREADPOOL_MAX_POOL_SIZE", this.defaultMaxThreadPoolSize);
        int maxThreadPoolSize = Integer.parseInt(maxThreadPoolSizeStr);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Glassfish thread pool settings: (" + this.minThreadPoolSize + "," + maxThreadPoolSize + "," + this.idleThreadTimeout + "," + (Object)((Object)TimeUnit.SECONDS) + "," + this.maxQueueSize + ")");
        }
        LinkedBlockingQueue<Runnable> queue = null;
        queue = this.maxQueueSize == -1 ? new LinkedBlockingQueue<Runnable>() : new LinkedBlockingQueue(this.maxQueueSize);
        this.executorService = new ThreadPoolExecutor(this.minThreadPoolSize, maxThreadPoolSize, this.idleThreadTimeout, TimeUnit.SECONDS, queue);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
    }
}

