/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.manager.documents.DocumentInfo;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.util.FacesLogger;
import jakarta.faces.FactoryFinder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseListener;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.faces.lifecycle.LifecycleFactory;
import jakarta.servlet.ServletContext;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LifecycleConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String LIFECYCLE = "lifecycle";
    private static final String PHASE_LISTENER = "phase-listener";
    private List<PhaseListener> appPhaseListeners = new CopyOnWriteArrayList<PhaseListener>();

    @Override
    public void process(ServletContext servletContext, FacesContext facesContext, DocumentInfo[] documentInfos) throws Exception {
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory("jakarta.faces.lifecycle.LifecycleFactory");
        for (int i = 0; i < documentInfos.length; ++i) {
            String namespace;
            Document document;
            NodeList lifecycles;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing lifecycle elements for document: ''{0}''", documentInfos[i].getSourceURI()));
            }
            if ((lifecycles = (document = documentInfos[i].getDocument()).getElementsByTagNameNS(namespace = document.getDocumentElement().getNamespaceURI(), LIFECYCLE)) == null) continue;
            int csize = lifecycles.getLength();
            for (int c = 0; c < csize; ++c) {
                Node lifecyleNode = lifecycles.item(c);
                if (lifecyleNode.getNodeType() != 1) continue;
                NodeList listeners = ((Element)lifecyleNode).getElementsByTagNameNS(namespace, PHASE_LISTENER);
                this.addPhaseListeners(servletContext, facesContext, factory, listeners);
            }
        }
    }

    @Override
    public void destroy(ServletContext sc, FacesContext facesContext) {
        this.destroyInstances(sc, facesContext, this.appPhaseListeners);
    }

    private void addPhaseListeners(ServletContext sc, FacesContext facesContext, LifecycleFactory factory, NodeList phaseListeners) {
        if (phaseListeners != null && phaseListeners.getLength() > 0) {
            int size = phaseListeners.getLength();
            for (int i = 0; i < size; ++i) {
                boolean[] didPerformInjection;
                PhaseListener phaseListener;
                Node phaseListenerNode = phaseListeners.item(i);
                String phaseListenerClassName = this.getNodeText(phaseListenerNode);
                if (phaseListenerClassName == null || (phaseListener = (PhaseListener)this.createInstance(sc, facesContext, phaseListenerClassName, PhaseListener.class, null, phaseListenerNode, true, didPerformInjection = new boolean[]{false})) == null) continue;
                if (didPerformInjection[0]) {
                    this.appPhaseListeners.add(phaseListener);
                }
                Iterator<String> t = factory.getLifecycleIds();
                while (t.hasNext()) {
                    String lfId = t.next();
                    Lifecycle lifecycle = factory.getLifecycle(lfId);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, MessageFormat.format("Adding PhaseListener ''{0}'' to lifecycle ''{0}}", phaseListenerClassName, lfId));
                    }
                    lifecycle.addPhaseListener(phaseListener);
                }
            }
        }
    }

    private void destroyInstances(ServletContext sc, FacesContext facesContext, List<?> instances) {
        for (Object instance : instances) {
            this.destroyInstance(sc, facesContext, instance.getClass().getName(), instance);
        }
        instances.clear();
    }
}

