/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.spi.AnnotatedCallable;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import jakarta.enterprise.lang.model.declarations.ParameterInfo;
import jakarta.enterprise.lang.model.types.TypeVariable;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jboss.weld.lite.extension.translator.ClassInfoImpl;
import org.jboss.weld.lite.extension.translator.DeclarationInfoImpl;
import org.jboss.weld.lite.extension.translator.ParameterInfoImpl;
import org.jboss.weld.lite.extension.translator.TypeImpl;
import org.jboss.weld.lite.extension.translator.TypeVariableImpl;
import org.jboss.weld.lite.extension.translator.util.reflection.AnnotatedTypes;

class MethodInfoImpl
extends DeclarationInfoImpl<Executable, AnnotatedCallable<?>>
implements MethodInfo {
    private final String className;
    private final String name;
    private final Type[] parameterTypes;

    MethodInfoImpl(AnnotatedCallable<?> cdiDeclaration, BeanManager bm) {
        super((Executable)cdiDeclaration.getJavaMember(), cdiDeclaration, bm);
        this.className = ((Executable)this.reflection).getDeclaringClass().getName();
        this.name = ((Executable)this.reflection).getName();
        this.parameterTypes = ((Executable)this.reflection).getGenericParameterTypes();
    }

    MethodInfoImpl(Executable reflectionDeclaration, BeanManager bm) {
        super(reflectionDeclaration, null, bm);
        this.className = reflectionDeclaration.getDeclaringClass().getName();
        this.name = reflectionDeclaration.getName();
        this.parameterTypes = reflectionDeclaration.getGenericParameterTypes();
    }

    public String name() {
        if (this.isConstructor()) {
            return ((Executable)this.reflection).getDeclaringClass().getName();
        }
        return ((Executable)this.reflection).getName();
    }

    public List<ParameterInfo> parameters() {
        HashMap<Parameter, AnnotatedParameter> map = new HashMap<Parameter, AnnotatedParameter>();
        for (AnnotatedParameter parameter : ((AnnotatedCallable)this.cdiDeclaration).getParameters()) {
            map.put(parameter.getJavaParameter(), parameter);
        }
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>();
        Parameter[] parameters = ((Executable)this.reflection).getParameters();
        boolean isEnumConstructorParam = this.isEnumConstructorParam(parameters);
        parameters = this.enumConstructorHack(parameters, isEnumConstructorParam);
        int position = 0;
        for (Parameter parameter : parameters) {
            if (parameter.isSynthetic()) continue;
            if (map.containsKey(parameter)) {
                result.add(new ParameterInfoImpl((AnnotatedParameter)map.get(parameter), this.bm));
            } else {
                result.add(new ParameterInfoImpl(parameter, this, position, isEnumConstructorParam, this.bm));
            }
            ++position;
        }
        return result;
    }

    private boolean isEnumConstructorParam(Parameter[] parameters) {
        return this.isConstructor() && ((Executable)this.reflection).getDeclaringClass().isEnum() && ((Executable)this.reflection).getGenericParameterTypes().length != parameters.length && parameters.length >= 2 && parameters[0].getType().equals(String.class) && parameters[1].getType().equals(Integer.TYPE);
    }

    private Parameter[] enumConstructorHack(Parameter[] parameters, boolean isEnumConstructorParam) {
        if (isEnumConstructorParam) {
            Parameter[] declaredParameters = new Parameter[parameters.length - 2];
            System.arraycopy(parameters, 2, declaredParameters, 0, declaredParameters.length);
            return declaredParameters;
        }
        return parameters;
    }

    public jakarta.enterprise.lang.model.types.Type returnType() {
        return TypeImpl.fromReflectionType(((Executable)this.reflection).getAnnotatedReturnType(), this.bm);
    }

    public jakarta.enterprise.lang.model.types.Type receiverType() {
        AnnotatedType receiverType = ((Executable)this.reflection).getAnnotatedReceiverType();
        if (receiverType == null) {
            return null;
        }
        return TypeImpl.fromReflectionType(receiverType, this.bm);
    }

    public List<jakarta.enterprise.lang.model.types.Type> throwsTypes() {
        return Arrays.stream(((Executable)this.reflection).getAnnotatedExceptionTypes()).map(annotatedType -> TypeImpl.fromReflectionType(annotatedType, this.bm)).collect(Collectors.toList());
    }

    public List<TypeVariable> typeParameters() {
        return Arrays.stream(((Executable)this.reflection).getTypeParameters()).map(AnnotatedTypes::typeVariable).map(annotatedTypeVariable -> new TypeVariableImpl((AnnotatedTypeVariable)annotatedTypeVariable, this.bm)).collect(Collectors.toList());
    }

    public boolean isConstructor() {
        return this.reflection instanceof Constructor;
    }

    public boolean isStatic() {
        return Modifier.isStatic(((Executable)this.reflection).getModifiers());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(((Executable)this.reflection).getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(((Executable)this.reflection).getModifiers());
    }

    public int modifiers() {
        return ((Executable)this.reflection).getModifiers();
    }

    public ClassInfo declaringClass() {
        return new ClassInfoImpl(this.bm.createAnnotatedType(((Executable)this.reflection).getDeclaringClass()), this.bm);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodInfoImpl)) {
            return false;
        }
        MethodInfoImpl that = (MethodInfoImpl)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.name, that.name) && Arrays.equals(this.parameterTypes, that.parameterTypes);
    }

    public int hashCode() {
        int result = Objects.hash(this.className, this.name);
        result = 31 * result + Arrays.hashCode(this.parameterTypes);
        return result;
    }
}

