/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployer;

import com.sun.enterprise.deployment.ManagedThreadFactoryDefinitionDescriptor;
import com.sun.enterprise.deployment.annotation.handlers.ContextualResourceDefinition;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.concurrent.runtime.ConcurrentRuntime;
import org.glassfish.concurrent.runtime.deployer.ConcurrencyDeployer;
import org.glassfish.concurrent.runtime.deployer.ConcurrencyManagedThreadFactoryConfig;
import org.glassfish.concurrent.runtime.deployer.cfg.ManagedThreadFactoryCfg;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedThreadFactoryImpl;
import org.glassfish.resourcebase.resources.api.GenericResourceInfo;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
@ResourceDeployerInfo(value=ManagedThreadFactoryDefinitionDescriptor.class)
public class ConcurrencyManagedThreadFactoryDeployer
extends ConcurrencyDeployer<ManagedThreadFactoryDefinitionDescriptor> {
    @Inject
    private InvocationManager invocationManager;
    @Inject
    private ResourceNamingService resourceNamingService;
    @Inject
    private ConcurrentRuntime runtime;

    public boolean handles(Object resource) {
        return resource instanceof ManagedThreadFactoryDefinitionDescriptor;
    }

    public void deployResource(ManagedThreadFactoryDefinitionDescriptor resource) throws Exception {
        String applicationName = this.invocationManager.getCurrentInvocation().getAppName();
        String moduleName = this.invocationManager.getCurrentInvocation().getModuleName();
        this.deployResource(resource, applicationName, moduleName);
    }

    public void deployResource(ManagedThreadFactoryDefinitionDescriptor resource, String applicationName, String moduleName) throws Exception {
        ManagedThreadFactoryDefinitionDescriptor descriptor = resource;
        ManagedThreadFactoryImpl factory = this.createThreadFactory(applicationName, moduleName, descriptor);
        SimpleJndiName resourceName = this.toResourceName(descriptor);
        ResourceInfo resourceInfo = new ResourceInfo(resourceName, applicationName, moduleName);
        this.resourceNamingService.publishObject((GenericResourceInfo)resourceInfo, (Object)factory, true);
    }

    public void undeployResource(ManagedThreadFactoryDefinitionDescriptor resource) throws Exception {
    }

    public void undeployResource(ManagedThreadFactoryDefinitionDescriptor resource, String applicationName, String moduleName) throws Exception {
    }

    private ManagedThreadFactoryImpl createThreadFactory(String applicationName, String moduleName, ManagedThreadFactoryDefinitionDescriptor descriptor) {
        ConcurrencyManagedThreadFactoryConfig config = new ConcurrencyManagedThreadFactoryConfig(descriptor);
        ManagedThreadFactoryCfg mtfConfig = new ManagedThreadFactoryCfg(config);
        ContextServiceImpl contextService = this.runtime.findOrCreateContextService((ContextualResourceDefinition)descriptor, applicationName, moduleName);
        return this.runtime.createManagedThreadFactory(mtfConfig, contextService);
    }
}

