/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.core;

import com.sun.tdk.signaturetest.core.ClassHierarchy;
import com.sun.tdk.signaturetest.model.ClassDescription;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ClassSet {
    private ClassHierarchy hierarchy;
    private boolean trackDependeces;
    private Map stack = new HashMap();
    private Map classes = new HashMap();
    private Set missingClasses = new HashSet();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$tdk$signaturetest$core$ClassSet;

    public ClassSet(ClassHierarchy hierarchy, boolean trackDependeces) {
        this.hierarchy = hierarchy;
        this.trackDependeces = trackDependeces;
    }

    public void addClass(String fqname) {
        this.addClass(fqname, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClass(String fqname, boolean externalCall) {
        if (this.stack.get(fqname) != null) {
            return;
        }
        this.stack.put(fqname, null);
        try {
            Counter counter = (Counter)this.classes.get(fqname);
            try {
                ClassDescription cl = this.hierarchy.load(fqname);
                if (!(this.hierarchy.isAccessible(cl) || externalCall || cl.isInterface())) {
                    this.addClass(cl.getSuperClass().getQualifiedName(), false);
                }
                if (counter == null) {
                    this.classes.put(fqname, new Counter(0));
                    if (this.trackDependeces) {
                        Set dep = cl.getDependences();
                        Iterator i = dep.iterator();
                        while (i.hasNext()) {
                            this.addClass((String)i.next(), false);
                        }
                    }
                } else {
                    counter.increment();
                }
            }
            catch (ClassNotFoundException e) {
                this.missingClasses.add(fqname);
            }
            Object var8_8 = null;
            this.stack.remove(fqname);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.stack.remove(fqname);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClass(String fqname) {
        if (this.stack.get(fqname) != null) {
            return;
        }
        this.stack.put(fqname, null);
        try {
            Counter counter = (Counter)this.classes.get(fqname);
            if (counter != null) {
                int c = counter.intValue();
                if (c == 0) {
                    this.classes.remove(fqname);
                    try {
                        ClassDescription cl = this.hierarchy.load(fqname);
                        Set dep = cl.getDependences();
                        Iterator i = dep.iterator();
                        while (i.hasNext()) {
                            this.removeClass((String)i.next());
                        }
                    }
                    catch (ClassNotFoundException e) {
                        if (!$assertionsDisabled && !this.missingClasses.contains(fqname)) {
                            throw new AssertionError();
                        }
                    }
                } else {
                    if (!$assertionsDisabled && c <= 0) {
                        throw new AssertionError();
                    }
                    counter.decrement();
                }
            }
            Object var8_8 = null;
            this.stack.remove(fqname);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.stack.remove(fqname);
            throw throwable;
        }
    }

    public Set getClasses() {
        return Collections.unmodifiableSet(this.classes.keySet());
    }

    public Set getMissingClasses() {
        return Collections.unmodifiableSet(this.missingClasses);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$tdk$signaturetest$core$ClassSet == null ? (class$com$sun$tdk$signaturetest$core$ClassSet = ClassSet.class$("com.sun.tdk.signaturetest.core.ClassSet")) : class$com$sun$tdk$signaturetest$core$ClassSet).desiredAssertionStatus();
    }

    private static final class Counter {
        int count;

        Counter(int c) {
            this.count = c;
        }

        void increment() {
            ++this.count;
        }

        void decrement() {
            --this.count;
        }

        int intValue() {
            return this.count;
        }
    }
}

