/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.interview;

import com.sun.interview.ChoiceQuestion;
import com.sun.interview.ErrorQuestion;
import com.sun.interview.ExtensionFileFilter;
import com.sun.interview.FileListQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.IntQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.YesNoQuestion;
import com.sun.javatest.ExcludeList;
import com.sun.javatest.ExcludeListFilter;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Vector;

public class ExcludeListInterview
extends Interview
implements Parameters.MutableExcludeListParameters {
    private InterviewParameters parent;
    private boolean initializedForTestSuite;
    private boolean hasInitialJTX;
    private boolean hasValidInitialJTX;
    private boolean hasLatestJTX;
    private boolean hasValidLatestJTX;
    private NeedExcludeListsQuestion qNeedExcludeLists;
    private static final String INITIAL = "initial";
    private static final String LATEST = "latest";
    private static final String CUSTOM = "custom";
    private ExcludeListTypeQuestion qExcludeListType;
    private YesNoQuestion qLatestAutoCheck = new YesNoQuestion(this, "latestAutoCheck", "No"){

        @Override
        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return ExcludeListInterview.this.qLatestAutoCheckMode;
            }
            return ExcludeListInterview.this.checkExcludeList();
        }
    };
    private static final String EVERY_X_DAYS = "everyXDays";
    private static final String EVERY_RUN = "everyRun";
    private ChoiceQuestion qLatestAutoCheckMode = new ChoiceQuestion(this, "latestAutoCheckMode"){
        {
            this.setChoices(new String[]{ExcludeListInterview.EVERY_X_DAYS, ExcludeListInterview.EVERY_RUN}, true);
        }

        @Override
        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value.equals(ExcludeListInterview.EVERY_X_DAYS)) {
                return ExcludeListInterview.this.qLatestAutoCheckInterval;
            }
            return ExcludeListInterview.this.checkExcludeList();
        }
    };
    private IntQuestion qLatestAutoCheckInterval = new IntQuestion(this, "latestAutoCheckInterval"){
        {
            this.setBounds(1, 365);
        }

        @Override
        public void clear() {
            this.setValue(7);
        }

        @Override
        protected Question getNext() {
            return ExcludeListInterview.this.checkExcludeList();
        }
    };
    private FileListQuestion qCustomFiles = new FileListQuestion(this, "customFiles"){
        {
            ExcludeListInterview.this.setResourceBundle("i18n");
            this.setFilter(new ExtensionFileFilter(".jtx", this.getResourceString("ExcludeListInterview.extn.desc", false)));
            this.setDuplicatesAllowed(false);
        }

        @Override
        protected Question getNext() {
            if (this.value == null || this.value.length == 0) {
                return null;
            }
            return ExcludeListInterview.this.checkExcludeList();
        }

        @Override
        public File getBaseDirectory() {
            TestSuite ts = ExcludeListInterview.this.parent.getTestSuite();
            return ts == null ? null : ts.getRootDir();
        }
    };
    private ExcludeList cachedExcludeList;
    private ExcludeListFilter cachedExcludeListFilter;
    private Question cachedExcludeListError;
    private Object[] cachedExcludeListErrorArgs;
    private TestSuite cachedExcludeList_testSuite;
    private File[] cachedExcludeList_files;
    private ErrorQuestion qExcludeListFileNotFound = new ErrorQuestion(this, "excludeListFileNotFound"){

        @Override
        protected Object[] getTextArgs() {
            return ExcludeListInterview.this.cachedExcludeListErrorArgs;
        }
    };
    private ErrorQuestion qExcludeListIOError = new ErrorQuestion(this, "excludeListIOError"){

        @Override
        protected Object[] getTextArgs() {
            return ExcludeListInterview.this.cachedExcludeListErrorArgs;
        }
    };
    private ErrorQuestion qExcludeListError = new ErrorQuestion(this, "excludeListError"){

        @Override
        protected Object[] getTextArgs() {
            return ExcludeListInterview.this.cachedExcludeListErrorArgs;
        }
    };
    private Question qEnd = new FinalQuestion(this);

    public ExcludeListInterview(InterviewParameters parent) throws Interview.Fault {
        super(parent, "excludeList");
        this.parent = parent;
        this.setResourceBundle("i18n");
        this.setHelpSet("/com/sun/javatest/moreInfo/moreInfo.hs");
        this.qNeedExcludeLists = new NeedExcludeListsQuestion();
        this.qExcludeListType = new ExcludeListTypeQuestion();
        this.setFirstQuestion(this.qNeedExcludeLists);
    }

    @Override
    public File[] getExcludeFiles() {
        if (this.qNeedExcludeLists.getValue() == "Yes") {
            TestSuite ts = this.parent.getTestSuite();
            String t = this.qExcludeListType.getValue();
            if (t == INITIAL) {
                File f;
                File file = f = ts == null ? null : ts.getInitialExcludeList();
                if (f == null) {
                    return null;
                }
                return new File[]{f};
            }
            if (t == LATEST) {
                URL u;
                URL uRL = u = ts == null ? null : ts.getLatestExcludeList();
                if (u == null) {
                    return null;
                }
                WorkDirectory wd = this.parent.getWorkDirectory();
                return new File[]{wd.getSystemFile("latest.jtx")};
            }
            return this.qCustomFiles.getValue();
        }
        return null;
    }

    @Override
    public void setExcludeFiles(File[] files) {
        if (files == null || files.length == 0) {
            this.setExcludeMode(1);
        } else {
            this.setExcludeMode(4);
            this.setCustomExcludeFiles(files);
        }
    }

    @Override
    public int getExcludeMode() {
        if (this.qNeedExcludeLists.getValue() == "Yes") {
            String t = this.qExcludeListType.getValue();
            if (t == INITIAL) {
                return 2;
            }
            if (t == LATEST) {
                return 3;
            }
            return 4;
        }
        return 1;
    }

    @Override
    public void setExcludeMode(int mode) {
        if (mode == 1) {
            this.qNeedExcludeLists.setValue("No");
        } else {
            this.qNeedExcludeLists.setValue("Yes");
            switch (mode) {
                case 2: {
                    this.qExcludeListType.setValue(INITIAL);
                    break;
                }
                case 3: {
                    this.qExcludeListType.setValue(LATEST);
                    break;
                }
                default: {
                    this.qExcludeListType.setValue(CUSTOM);
                }
            }
        }
    }

    @Override
    public File[] getCustomExcludeFiles() {
        return this.qCustomFiles.getValue();
    }

    @Override
    public void setCustomExcludeFiles(File[] files) {
        this.qCustomFiles.setValue(files);
    }

    @Override
    public boolean isLatestExcludeAutoCheckEnabled() {
        return this.qLatestAutoCheck.getValue() == "Yes";
    }

    @Override
    public void setLatestExcludeAutoCheckEnabled(boolean b) {
        this.qLatestAutoCheck.setValue(b ? "Yes" : "No");
    }

    @Override
    public int getLatestExcludeAutoCheckMode() {
        return this.qLatestAutoCheckMode.getValue() == EVERY_X_DAYS ? 1 : 2;
    }

    @Override
    public void setLatestExcludeAutoCheckMode(int mode) {
        if (mode == 1) {
            this.qLatestAutoCheckMode.setValue(EVERY_X_DAYS);
        } else {
            this.qLatestAutoCheckMode.setValue(EVERY_RUN);
        }
    }

    @Override
    public int getLatestExcludeAutoCheckInterval() {
        return this.qLatestAutoCheckInterval.getValue();
    }

    @Override
    public void setLatestExcludeAutoCheckInterval(int days) {
        this.qLatestAutoCheckInterval.setValue(days);
    }

    @Override
    public ExcludeList getExcludeList() {
        this.updateCachedExcludeListData();
        return this.cachedExcludeList;
    }

    public TestFilter getExcludeFilter() {
        this.updateCachedExcludeListData();
        return this.cachedExcludeListFilter;
    }

    private void ensureInitializedForTestSuite() {
        WorkDirectory wd;
        if (this.initializedForTestSuite) {
            return;
        }
        TestSuite ts = this.parent.getTestSuite();
        if (ts == null) {
            return;
        }
        File ijtx = ts.getInitialExcludeList();
        this.hasInitialJTX = ijtx != null;
        this.hasValidInitialJTX = this.hasInitialJTX && ijtx.exists();
        URL ljtx = ts.getLatestExcludeList();
        boolean bl = this.hasLatestJTX = ljtx != null;
        this.hasValidLatestJTX = this.hasLatestJTX ? (wd = this.parent.getWorkDirectory()) != null && wd.getSystemFile("latest.jtx").exists() : false;
        this.initializedForTestSuite = true;
    }

    private void updateCachedExcludeListData() {
        TestSuite ts = this.parent.getTestSuite();
        File tsRootDir = ts == null ? null : ts.getRootDir();
        File[] files = ExcludeListInterview.getAbsoluteFiles(tsRootDir, this.getExcludeFiles());
        if (!ExcludeListInterview.equal(this.cachedExcludeList_files, files) || this.cachedExcludeList_testSuite != ts) {
            try {
                if (ts == null || files == null || files.length == 0) {
                    this.setCachedExcludeList(new ExcludeList());
                } else {
                    this.setCachedExcludeList(new ExcludeList(files));
                }
            }
            catch (FileNotFoundException e) {
                this.setCachedExcludeListError(this.qExcludeListFileNotFound, e.getMessage());
            }
            catch (IOException e) {
                this.setCachedExcludeListError(this.qExcludeListIOError, e.toString());
            }
            catch (ExcludeList.Fault e) {
                this.setCachedExcludeListError(this.qExcludeListError, e.getMessage());
            }
            this.cachedExcludeList_files = files;
            this.cachedExcludeList_testSuite = ts;
        }
    }

    private void setCachedExcludeList(ExcludeList l) {
        this.cachedExcludeList = l;
        this.cachedExcludeListFilter = l.isEmpty() ? null : new ExcludeListFilter(l);
        this.cachedExcludeListError = null;
        this.cachedExcludeListErrorArgs = null;
    }

    private void setCachedExcludeListError(Question q, String arg) {
        this.cachedExcludeList = new ExcludeList();
        this.cachedExcludeListFilter = null;
        this.cachedExcludeListError = q;
        this.cachedExcludeListErrorArgs = new String[]{arg};
    }

    private Question checkExcludeList() {
        this.updateCachedExcludeListData();
        if (this.cachedExcludeListError != null) {
            return this.cachedExcludeListError;
        }
        return this.qEnd;
    }

    private static File[] getAbsoluteFiles(File baseDir, File[] files) {
        if (files == null) {
            return null;
        }
        if (baseDir == null) {
            return files;
        }
        boolean allAbsolute = true;
        for (int i = 0; i < files.length && allAbsolute; ++i) {
            allAbsolute = files[i].isAbsolute();
        }
        if (allAbsolute) {
            return files;
        }
        File[] absoluteFiles = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            absoluteFiles[i] = f.isAbsolute() ? f : new File(baseDir, f.getPath());
        }
        return absoluteFiles;
    }

    private static boolean equal(File f1, File f2) {
        return f1 == null ? f2 == null : f1.equals(f2);
    }

    private static boolean equal(File[] f1, File[] f2) {
        if (f1 == null || f2 == null) {
            return f1 == f2;
        }
        if (f1.length != f2.length) {
            return false;
        }
        for (int i = 0; i < f1.length; ++i) {
            if (f1[i] == f2[i]) continue;
            return false;
        }
        return true;
    }

    private class ExcludeListTypeQuestion
    extends ChoiceQuestion {
        private boolean initialized;
        private String defaultValue;

        ExcludeListTypeQuestion() {
            super(ExcludeListInterview.this, "excludeListType");
            this.setChoices(new String[]{null, ExcludeListInterview.INITIAL, ExcludeListInterview.LATEST, ExcludeListInterview.CUSTOM}, true);
            this.clear();
        }

        @Override
        public void clear() {
            this.ensureInitialized();
            this.setValue(this.defaultValue);
        }

        @Override
        public String[] getChoices() {
            this.ensureInitialized();
            return super.getChoices();
        }

        @Override
        public void save(Map data) {
            this.ensureInitialized();
            super.save(data);
        }

        @Override
        public boolean isHidden() {
            return this.getChoices().length == 2;
        }

        @Override
        public String getValue() {
            return this.isHidden() ? ExcludeListInterview.CUSTOM : super.getValue();
        }

        @Override
        protected Question getNext() {
            if (this.isHidden()) {
                return ExcludeListInterview.this.qCustomFiles;
            }
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            if (this.value.equals(ExcludeListInterview.INITIAL)) {
                return ExcludeListInterview.this.checkExcludeList();
            }
            if (this.value.equals(ExcludeListInterview.LATEST)) {
                return ExcludeListInterview.this.qLatestAutoCheck;
            }
            return ExcludeListInterview.this.qCustomFiles;
        }

        private void ensureInitialized() {
            if (this.initialized) {
                return;
            }
            if (ExcludeListInterview.this.parent.getTestSuite() == null) {
                return;
            }
            ExcludeListInterview.this.ensureInitializedForTestSuite();
            String defaultValue = ExcludeListInterview.CUSTOM;
            Vector<String> v = new Vector<String>(4);
            v.add(null);
            if (ExcludeListInterview.this.hasValidInitialJTX) {
                v.add(ExcludeListInterview.INITIAL);
            }
            if (ExcludeListInterview.this.hasLatestJTX) {
                v.add(ExcludeListInterview.LATEST);
            }
            v.add(ExcludeListInterview.CUSTOM);
            Object[] choices = new String[v.size()];
            v.copyInto(choices);
            this.initialized = true;
            this.setChoices((String[])choices, true);
            defaultValue = ExcludeListInterview.this.hasValidLatestJTX ? ExcludeListInterview.LATEST : (ExcludeListInterview.this.hasValidInitialJTX ? ExcludeListInterview.INITIAL : null);
            this.setValue(defaultValue);
        }
    }

    private class NeedExcludeListsQuestion
    extends YesNoQuestion {
        private boolean doneSuper;

        NeedExcludeListsQuestion() {
            super(ExcludeListInterview.this, "needExcludeList");
            this.doneSuper = true;
            this.clear();
        }

        @Override
        public void clear() {
            if (!this.doneSuper) {
                return;
            }
            ExcludeListInterview.this.ensureInitializedForTestSuite();
            this.setValue(ExcludeListInterview.this.hasValidInitialJTX || ExcludeListInterview.this.hasValidLatestJTX ? "Yes" : "No");
        }

        @Override
        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return ExcludeListInterview.this.qExcludeListType;
            }
            return ExcludeListInterview.this.qEnd;
        }
    }
}

