/*
* Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
* ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/

/*
 * $Id: LocalTxActivationSpec.java 67292 2012-08-23 20:45:07Z phendley $
 */

package com.sun.ts.tests.common.connector.whitebox;

import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import com.sun.ts.tests.common.connector.util.*;

public class LocalTxActivationSpec implements ActivationSpec, java.io.Serializable {

    private String destinationName;
    private String destinationType;
    private ResourceAdapter resourceAdapter;
    private int counter = 0;

   /**
     * Default constructor.
     */
    public LocalTxActivationSpec ()
    {
    
    }

    public String getDestinationName() 
    {
        System.out.println("LocalTxActivationSpec.getDestinationName :"+this.destinationName);
        return this.destinationName;
    }

    public void setDestinationName(String name)
    {
        this.destinationName = name;
        System.out.println("LocalTxActivationSpec.setDestinationName :"+name);
    }

    public String getDestinationType()
    {
        System.out.println("LocalTxActivationSpec.getDestinationType :"+this.destinationType);
        return this.destinationType;
    }

    public void setDestinationType(String type)
    {
        System.out.println("LocalTxActivationSpec.setDestinationType :"+type);
        this.destinationType = type;
    }

    @Override
    public ResourceAdapter getResourceAdapter () {
        return this.resourceAdapter;
    }

    @Override
    public void setResourceAdapter (ResourceAdapter ra) {
        counter++;
        ConnectorStatus.getConnectorStatus().logState("LocalTxActivationSpec setResourceAdapter "+counter);
        System.out.println("LocalTxActivationSpec.setResourceAdatper called");
        this.resourceAdapter = ra;
    }

    @Override
    public void validate() {
        throw new UnsupportedOperationException();
    } 

    public void setCounter(int val)
    {
        this.counter = val;
    }

    public int getCounter()
    {
      return this.counter;
    }

}
