/*
* Copyright (c) 2007, 2011, Oracle and/or its affiliates. All rights reserved.
* ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/

/*
 * $Id: Util.java 62543 2011-04-15 16:55:11Z phendley $
 */

package com.sun.ts.tests.common.connector.whitebox;

import java.util.*;
import javax.security.auth.Subject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.resource.spi.security.PasswordCredential;
import javax.resource.ResourceException;
import javax.resource.spi.SecurityException;
import javax.resource.spi.*;

public class Util {
    static public PasswordCredential getPasswordCredential
        (final ManagedConnectionFactory mcf,
         final Subject subject, ConnectionRequestInfo info)
        throws ResourceException {

        if (subject == null) {
            if (info == null) {
                return null;
            } else {
                TSConnectionRequestInfo myinfo =
                    (TSConnectionRequestInfo) info;
                PasswordCredential pc = 
                    new PasswordCredential(myinfo.getUser(),
                                           myinfo.getPassword().toCharArray());
                pc.setManagedConnectionFactory(mcf);
                return pc;
            }
        } else {
            PasswordCredential pc = 
            (PasswordCredential) AccessController.doPrivileged
                (new PrivilegedAction() {
                    public Object run() {
                        Set creds = subject.getPrivateCredentials
                            (PasswordCredential.class);
                        Iterator iter = creds.iterator();
                        while (iter.hasNext()) {
                            PasswordCredential temp = 
                                (PasswordCredential) iter.next();
                            if (temp.getManagedConnectionFactory().
                                equals(mcf)) {
                                return temp;
                            }
                        }
                        return null;
                    }
                });
            if (pc == null) {
                throw new SecurityException("No PasswordCredential found");
            } else {
                return pc;
            }
        }
    }
    
    static public boolean isEqual(String a, String b) {
        if (a == null) {
            return (b == null);
        } else {
            return a.equals(b);
        }
    }

    static public boolean isPasswordCredentialEqual(PasswordCredential a,
                                                    PasswordCredential b) {
        if (a == b) return true;
        if ((a == null) && (b != null)) return false;
        if ((a != null) && (b == null)) return false;
        if (!isEqual(a.getUserName(), b.getUserName())) return false;
        String p1 = null;
        String p2 = null;
        if (a.getPassword() != null) {
            p1 = new String(a.getPassword());
        }
        if (b.getPassword() != null) {
            p2 = new String(b.getPassword());
        }
        return (isEqual(p1, p2));
    }

}
