/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Result.java 62564 2011-04-18 20:29:25Z kgrucci $
 */
package com.sun.ts.lib.tests.jbi;

import java.io.*;
import java.util.List;
import java.util.ArrayList;
import com.sun.javatest.Status;

/*
 * This class represents a result object returned from a JBI component to
 * a client CTS test.  This class must be serializable since the result
 * will need to be sent between VMs.
 */
public class Result implements Serializable {

    private static final long serialVersionUID = 1L;

    private boolean passed;
    private List    messages;

    public Result(boolean passed, List messages) {
	this.passed = passed;
	this.messages = messages;
    }

    public Result(Status status) {
	this(status.isPassed(), status.getReason());
    }

    public Result(boolean passed, String message) {
	this(passed);
	addMessage(message);
    }

    public Result(boolean passed) {
	this(passed, new ArrayList());
    }

    public Result() {
	this(false);
    }

    public List getMessages() {
	return messages;
    }

    public void addMessage(String message) {
	messages.add(message);
    }

    public boolean passed() {
	return passed;
    }

    public void setPassed(boolean passed) {
	this.passed = passed;
    }

    public String toString() {
	StringBuffer buf = new StringBuffer("Test Result:" + Constants.NL);
	buf.append("\t" + "Passed is: " + passed() + Constants.NL);
	buf.append("\t" + "Messages:" + Constants.NL);
	int numMessages = (messages == null) ? 0 : messages.size();
	for (int i = 0; i < numMessages; i++) {
	    String message = (String)messages.get(i);
	    buf.append("\t\t" + i + ". " + message + Constants.NL);
	}
	return buf.toString();
    }

    public void write(String file, boolean deleteExisting) throws Exception {
	File f = new File(file);
	write(f, deleteExisting);
    }

    public void write(File f, boolean deleteExisting) throws Exception {
	if (deleteExisting && f.exists()) {
	    try {
		f.delete();
	    } catch (Exception e) { /* do nothing */ }
	}
	ObjectOutputStream oos = null;
	try {
	    oos = new ObjectOutputStream(new FileOutputStream(f));
	    oos.writeObject(this);
	    System.err.println("Results written to \"" + f.getPath() + "\"");
	} finally {
	    try { oos.close(); } catch (Exception ee) { /* do nothing */}
	}
    }
    
    public Status asStatus() {
	if (passed) {
	    return new Status(Status.PASSED, toString());
	} else {
	    return new Status(Status.FAILED, toString());
	}
    }

} // end class Result
