/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: RemoteCalculator.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.calc;

/**
 * A calculator with special remoteAdd and removeSubtract operations.
 * @author  Cheng Fang
 */

public interface RemoteCalculator {
    public static final int EXTRA = 0;
    
    /**
     * @param a
     * @param b
     * @return a + b + RemoteCalculator.EXTRA
     */
    public int remoteAdd(int a, int b);
    
    /**
     * @param a 
     * @param b
     * @return a - b + RemoteCalculator.EXTRA
     */
    public int remoteSubtract(int a, int b);
    
    public void remoteThrowIt() throws CalculatorException;
}
