/*
 * Copyright (c) 2007, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: HttpTCKServlet.java 71179 2013-03-27 18:32:00Z djiao $
 */


package com.sun.ts.tests.servlet.common.servlets;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * GenericTCKServlet.java
 *
 * Any test that would normally extend GenericServlet will
 * instead extend this class.  This will provide a simple
 * framework from invoking various tests defined as methods
 * within the servlet that extends this class.
 *
 * Created: Wed Jul 31 20:57:16 2002
 *
 * @author <a href="mailto:Ryan.Lubke@Sun.COM">Ryan Lubke</a>
 * @version %I%
 */

public abstract class HttpTCKServlet extends HttpServlet {

    private static final String TEXT_PLAIN = "text/plain";

    /**
     * <code>TEST_HEADER</code> is the constant for the
     * <code>testname</code> header.
     */
    private static final String TEST_HEADER = "testname";

    /**
     * <code>TEST_ARGS</code> is an array of Classes used
     * during reflection.
     */
    private static final Class[] TEST_ARGS = {HttpServletRequest.class,
                                              HttpServletResponse.class};

    /**
     * <code>init</code> initializes the servlet.
     *
     * @param config - <code>ServletConfig</code>
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    /**
     * <code>invokeTest</code> uses reflection to invoke test methods
     * in child classes of this particular class.
     *
     * @param req - <code>HttpServletRequest</code>
     * @param res - <code>HttpServletResponse</code>
     * @exception ServletException if an error occurs
     */
    protected void invokeTest(HttpServletRequest req, HttpServletResponse res)
        throws ServletException {
        res.setContentType(TEXT_PLAIN);
        char[] temp = req.getParameter(TEST_HEADER).toCharArray();
        temp[0] = Character.toLowerCase(temp[0]);
        String test = new String(temp);

        try {
            Method method = this.getClass().getMethod(test, TEST_ARGS);
            method.invoke(this, new Object[]{req, res});
        } catch (InvocationTargetException ite) {
            throw new ServletException(ite.getTargetException());
        } catch (NoSuchMethodException nsme) {
            throw new ServletException("Test: " + test + " does not exist");
        } catch (Throwable t) {
            throw new ServletException("Error executing test: " + test, t);
        }
    }

    /**
     * A basic implementation of the <code>doGet</code> method which will
     * call invokeTest.
     *
     * @param req - <code>HttpServletRequest</code>
     * @param res - <code>HttpServletResponse</code>
     * @exception ServletException if an error occurs
     * @exception IOException if an IO error occurs
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res)
        throws ServletException, IOException {
        invokeTest(req, res);
    }

    /**
     * A basic implementation of the <code>doPost</code> method which will
     * call invokeTest.
     *
     * @param req - <code>HttpServletRequest</code>
     * @param res - <code>HttpServletResponse</code>
     * @exception ServletException if an error occurs
     * @exception IOException if an IO error occurs
     */
    public void doPost(HttpServletRequest req, HttpServletResponse res)
        throws ServletException, IOException {
        invokeTest(req, res);
    }

}// HttpTCKServlet
