/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: ClientBase2.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.callback;

import com.sun.ts.tests.ejb30.common.helper.TLogger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.omg.CORBA.ORB;

abstract public class ClientBase2 extends ClientBase2NoAnnotation {
    @Resource
    private static ORB orbInClientBase2;
    
    public ClientBase2() {
    }
    
    /**
     * When this method is invoked, all injections, including those in this
     * class, and all of its subclasses, should have been completed.
     */
    @PostConstruct
    private static void postConstructInBase2() {
        addPostConstructCall(BASE2);
        //check injected fields
        if(orbInClientBase2 != null) {
            addInjectedField(orbInClientBase2);
        } else {
            TLogger.log("WARNING: ClientBase2.orbInClientBase2 has not been " +
            "initialized when checking inside ClientBase2.postConstructInBase2()");
        }
    }
}
