/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: MigrationBeanBase.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.migration.threetwo;
import javax.ejb.CreateException;
import javax.ejb.EJBContext;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

abstract public class MigrationBeanBase implements SessionBean {
    private SessionContext sessionContext;
    
    protected EJBContext getEJBContext() {
        return this.sessionContext;
    }
    
    public void ejbCreate() throws CreateException {
    }
    
    public void setSessionContext(javax.ejb.SessionContext sessionContext)  {
        this.sessionContext = sessionContext;
    }

    public void ejbRemove()  {
    }

    public void ejbPassivate()  {
    }

    public void ejbActivate()  {
    }
    
    //////////////////////////////////////////////////////////////////////
    //TwoRemoteIF methods
    //////////////////////////////////////////////////////////////////////
    public String from2RemoteClient() {
        return "from2RemoteClient";
    }
    
    public void remoteSameTxContext() {
        getEJBContext().setRollbackOnly();
    }
    
    //////////////////////////////////////////////////////////////////////
    //TwoLocalIF methods
    //////////////////////////////////////////////////////////////////////
    public String from2LocalClient() {
        return "from2LocalClient";
    }
    
    public void localSameTxContext() {
        getEJBContext().setRollbackOnly();
    }

}
