/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.net.URL;
import javax.help.JHelpContentViewer;
import javax.help.Map;
import javax.help.TextHelpModel;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

class DetailsBrowser
extends JDialog {
    private JTextField tagField;
    private JTextField keyField;
    private JTextField hsField;
    private JTextField idField;
    private JTextField urlField;

    DetailsBrowser(Component parent, Interview interview, JHelpContentViewer infoPanel) {
        super(DetailsBrowser.getFrameParent(parent), "Configuration Editor Details Browser", false);
        this.setDefaultCloseOperation(1);
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets.left = 5;
        c.insets.right = 5;
        c.insets.bottom = 5;
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        Listener listener = new Listener();
        GridBagConstraints lc = new GridBagConstraints();
        lc.anchor = 13;
        lc.insets.left = 10;
        GridBagConstraints fc = new GridBagConstraints();
        fc.fill = 2;
        fc.gridwidth = 0;
        fc.weightx = 1.0;
        fc.insets.left = 10;
        fc.insets.right = 10;
        JPanel qp = new JPanel(new GridBagLayout());
        qp.setBorder(BorderFactory.createTitledBorder("Current Question"));
        JLabel tagLbl = new JLabel("tag:");
        qp.add((Component)tagLbl, lc);
        this.tagField = new JTextField(64);
        this.tagField.setBorder(null);
        this.tagField.setEditable(false);
        qp.add((Component)this.tagField, fc);
        JLabel keyLbl = new JLabel("key:");
        qp.add((Component)keyLbl, lc);
        this.keyField = new JTextField(64);
        this.keyField.setBorder(null);
        this.keyField.setEditable(false);
        qp.add((Component)this.keyField, fc);
        this.update(interview.getCurrentQuestion());
        interview.addObserver(listener);
        p.add((Component)qp, c);
        if (infoPanel != null) {
            JPanel mp = new JPanel(new GridBagLayout());
            mp.setBorder(BorderFactory.createTitledBorder("More Info"));
            JLabel hsLbl = new JLabel("helpset:");
            mp.add((Component)hsLbl, lc);
            this.hsField = new JTextField(64);
            this.hsField.setBorder(null);
            this.hsField.setEditable(false);
            mp.add((Component)this.hsField, fc);
            JLabel idLbl = new JLabel("id:");
            mp.add((Component)idLbl, lc);
            this.idField = new JTextField(64);
            this.idField.setBorder(null);
            this.idField.setEditable(false);
            mp.add((Component)this.idField, fc);
            JLabel urlLbl = new JLabel("url:");
            mp.add((Component)urlLbl, lc);
            this.urlField = new JTextField(64);
            this.urlField.setBorder(null);
            this.urlField.setEditable(false);
            mp.add((Component)this.urlField, fc);
            TextHelpModel m = infoPanel.getModel();
            this.update(m.getCurrentID(), m.getCurrentURL());
            m.addHelpModelListener(listener);
            p.add((Component)mp, c);
        }
        this.setContentPane(p);
        this.pack();
    }

    void setQuestionInfoEnabled(boolean on) {
        this.keyField.setEnabled(on);
        this.tagField.setEnabled(on);
    }

    private void update(Question q) {
        this.tagField.setText(q.getTag());
        this.keyField.setText(q.getKey());
    }

    private void update(Map.ID id, URL u) {
        this.hsField.setText(id.getHelpSet().getTitle());
        this.idField.setText(id.getIDString());
        this.urlField.setText(u.toString());
    }

    private static Frame getFrameParent(Component c) {
        return (Frame)SwingUtilities.getAncestorOfClass(Frame.class, c);
    }

    private class Listener
    implements HelpModelListener,
    Interview.Observer {
        private Listener() {
        }

        @Override
        public void idChanged(HelpModelEvent e) {
            DetailsBrowser.this.update(e.getID(), e.getURL());
        }

        @Override
        public void pathUpdated() {
        }

        @Override
        public void currentQuestionChanged(Question q) {
            DetailsBrowser.this.update(q);
        }

        public void finished() {
        }
    }
}

