/*
 * Decompiled with CFR 0.152.
 */
package org.freebxml.omar.common;

import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.registry.RegistryException;
import org.freebxml.omar.common.CredentialInfo;
import org.freebxml.omar.common.LifeCycleManager;
import org.freebxml.omar.common.LifeCycleManagerFactory;
import org.freebxml.omar.common.QueryManager;
import org.freebxml.omar.common.QueryManagerFactory;
import org.freebxml.omar.common.RepositoryItemImpl;
import org.freebxml.omar.common.SOAPMessenger;
import org.oasis.ebxml.registry.bindings.lcm.ApproveObjectsRequest;
import org.oasis.ebxml.registry.bindings.lcm.DeprecateObjectsRequest;
import org.oasis.ebxml.registry.bindings.lcm.RelocateObjectsRequest;
import org.oasis.ebxml.registry.bindings.lcm.RemoveObjectsRequest;
import org.oasis.ebxml.registry.bindings.lcm.SubmitObjectsRequest;
import org.oasis.ebxml.registry.bindings.lcm.UndeprecateObjectsRequest;
import org.oasis.ebxml.registry.bindings.lcm.UpdateObjectsRequest;
import org.oasis.ebxml.registry.bindings.rim.UserType;
import org.oasis.ebxml.registry.bindings.rs.RegistryResponse;

public class LifeCycleManagerLocalProxy
implements LifeCycleManager {
    private LifeCycleManager serverLCM = LifeCycleManagerFactory.getInstance().getLifeCycleManager();
    private QueryManager serverQM = QueryManagerFactory.getInstance().getQueryManager();
    private String registryURL = null;
    private CredentialInfo credentialInfo = null;
    private SOAPMessenger msgr = null;

    public LifeCycleManagerLocalProxy(String registryURL, CredentialInfo credentialInfo) {
        this.msgr = new SOAPMessenger(registryURL, credentialInfo);
        this.credentialInfo = credentialInfo;
    }

    public RegistryResponse approveObjects(UserType user, ApproveObjectsRequest req) throws RegistryException {
        return this.serverLCM.approveObjects(this.getCallersUser(), req);
    }

    public RegistryResponse deprecateObjects(UserType user, DeprecateObjectsRequest req) throws RegistryException {
        return this.serverLCM.deprecateObjects(this.getCallersUser(), req);
    }

    public RegistryResponse unDeprecateObjects(UserType user, UndeprecateObjectsRequest req) throws RegistryException {
        return this.serverLCM.unDeprecateObjects(this.getCallersUser(), req);
    }

    public RegistryResponse removeObjects(UserType user, RemoveObjectsRequest req) throws RegistryException {
        return this.serverLCM.removeObjects(this.getCallersUser(), req);
    }

    public RegistryResponse submitObjects(UserType user, SubmitObjectsRequest req, HashMap idToRepositoryItemMap) throws RegistryException {
        this.convertRepositoryItemMap(idToRepositoryItemMap);
        return this.serverLCM.submitObjects(this.getCallersUser(), req, idToRepositoryItemMap);
    }

    public RegistryResponse updateObjects(UserType user, UpdateObjectsRequest req, HashMap idToRepositoryItemMap) throws RegistryException {
        this.convertRepositoryItemMap(idToRepositoryItemMap);
        return this.serverLCM.updateObjects(this.getCallersUser(), req, idToRepositoryItemMap);
    }

    private void convertRepositoryItemMap(HashMap idToRepositoryItemMap) throws RegistryException {
        Set keys = idToRepositoryItemMap.keySet();
        Iterator keysIter = keys.iterator();
        while (keysIter.hasNext()) {
            Object key = keysIter.next();
            DataHandler dh = (DataHandler)idToRepositoryItemMap.get(key);
            RepositoryItemImpl ri = new RepositoryItemImpl((String)key, dh);
            idToRepositoryItemMap.put(key, ri);
        }
    }

    private UserType getCallersUser() throws RegistryException {
        X509Certificate cert = null;
        if (this.credentialInfo != null) {
            cert = this.credentialInfo.cert;
        }
        return this.serverQM.getUser(cert);
    }

    public RegistryResponse relocateObjects(UserType user, RelocateObjectsRequest req) throws RegistryException {
        return this.serverLCM.relocateObjects(this.getCallersUser(), req);
    }
}

