/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: CompoundTestImpl.java 62602 2011-04-21 14:51:41Z kgrucci $
 */


package com.sun.ts.tests.jaxws.ee.w2j.rpc.literal.marshalltest;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;

import javax.xml.ws.WebServiceException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPException;

import javax.jws.WebService;

@WebService(
    targetNamespace="http://marshalltestservice.org/MarshallTestService.wsdl",
    portName="MarshallTestPort3",
    serviceName="MarshallTestService",
    wsdlLocation="WEB-INF/wsdl/WSW2JRLMarshallTestService.wsdl",
    endpointInterface="com.sun.ts.tests.jaxws.ee.w2j.rpc.literal.marshalltest.CompoundTest"
)
public class CompoundTestImpl implements CompoundTest {
    public EchoEmployeeResponse echoEmployee(EchoEmployeeRequest employee) 
						 {
        EchoEmployeeResponse employeeResp = new EchoEmployeeResponse();
        employeeResp.setEmployee(employee.getEmployee());
        return employeeResp;
    }

    public EchoPersonResponse echoPerson(EchoPersonRequest person) 
						 {
        EchoPersonResponse personResp = new EchoPersonResponse();
        personResp.setPerson(person.getPerson());
        return personResp;
    }
	
    public Document echoDocument(Document document)  {
	return document;
    }
}
