/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $URL: https://adc4110351.us.oracle.com/svn/spider/branches/cts/8.0/src/com/sun/ts/tests/jaxws/wsi/w2j/document/literal/R2712/W2JDLR2712ClientTwo.java $ $LastChangedDate: 2011-04-21 07:51:41 -0700 (Thu, 21 Apr 2011) $
 */

package com.sun.ts.tests.jaxws.wsi.w2j.document.literal.R2712;

import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;
import com.sun.ts.lib.harness.EETest;

public class W2JDLR2712ClientTwo extends SOAPClient{

    public W2JDLR2712ClientTwo(String webServerHost, int webServerPort, int mode) throws EETest.Fault {
	this(webServerHost, webServerPort, mode, null);
    }

    public W2JDLR2712ClientTwo(String webServerHost, int port, int mode, javax.xml.ws.Service webServiceRef) throws EETest.Fault{

        super(webServerHost, port, mode);
        stubContext.setNamespace("http://w2jdlr2712testservice.org/wsdl");
        stubContext.setService("W2JDLR2712TestService");
        stubContext.setPort("W2JDLR2712TestTwoPort");
        stubContext.setEndpointInterface(W2JDLR2712TestTwo.class);
	stubContext.setWebServiceRef(webServiceRef);
    }

    protected String getEndpointURLProperty() {
        return "wsi.w2jdlr2712.endpoint.2";
    }

    protected String getWSDLURLProperty() {
        return "wsi.w2jdlr2712.wsdlloc.1";
    }

    public HelloResponse hello(HelloRequest item) throws Exception {
        return ((W2JDLR2712TestTwo)stubContext.getStub()).hello(item);
    }

}
