/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: W2JRLR1027Client.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R1027;

import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;
import com.sun.ts.lib.harness.EETest;

public class W2JRLR1027Client extends SOAPClient{
    public W2JRLR1027Client(String webServerHost, int port, int mode) throws EETest.Fault{
        this(webServerHost, port, mode, null);
    }

    public W2JRLR1027Client(String webServerHost, int port, int mode, javax.xml.ws.Service webServiceRef) throws EETest.Fault{
        super(webServerHost, port, mode);
        stubContext.setNamespace("http://simpletestservice.org/wsdl");
        stubContext.setService("SimpleTest");
        stubContext.setPort("SimpleEndpointPort");
        stubContext.setEndpointInterface(SimpleEndpoint.class);
	stubContext.setWebServiceRef(webServiceRef);
    }

    protected String getEndpointURLProperty() {
        return "wsi.w2jrlr1027.endpoint.1";
    }

    protected String getWSDLURLProperty() {
        return "wsi.w2jrlr1027.wsdlloc.1";
    }

    public String helloWorld() throws Exception{
        return ((SimpleEndpoint)stubContext.getStub()).helloWorld();
    }
}
