/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: W2JRLR11XXClientOne.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R11XX;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;

public class W2JRLR11XXClientOne extends SOAPClient{
    public W2JRLR11XXClientOne(String webServerHost, int port, int mode) throws EETest.Fault{
        this(webServerHost, port, mode, null);
    }

    public W2JRLR11XXClientOne(String webServerHost, int port, int mode, javax.xml.ws.Service webServiceRef) throws EETest.Fault{
        super(webServerHost, port, mode);
        stubContext.setNamespace("http://soapactionservice.org/wsdl/");
        stubContext.setService("W2JRLR11XXTestService");
        stubContext.setPort("W2JRLR11XXTestOnePort");
        stubContext.setEndpointInterface(W2JRLR11XXTest.class);
	stubContext.setWebServiceRef(webServiceRef);
    }

    protected String getEndpointURLProperty() {
        return "wsi.w2jrlr11XX.endpoint.1";
    }

    protected String getWSDLURLProperty() {
        return "wsi.w2jrlr11XX.wsdlloc.1";
    }

    public String echoString(String s) throws Exception{
        return ((W2JRLR11XXTest)stubContext.getStub()).echoString(s);
    }
}
