/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: R2753Handler.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/*
 * $Id: R2753Handler.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R2753;

import com.sun.ts.tests.jaxws.common.Handler_Util;
import com.sun.ts.tests.jaxws.common.Constants;

import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.ws.handler.MessageContext;
import javax.xml.namespace.QName;
import javax.xml.soap.*;

import java.util.Set;
import java.util.HashSet;

public class R2753Handler implements SOAPHandler<SOAPMessageContext> {

    public Set<QName> getHeaders() {
        Set<QName> s = new HashSet<QName>();
        s.add(new QName("http://extra-header.org", "extra-header"));
        return s;
    }

    public void init(java.util.Map<String,Object> config) {
    };

    public boolean handleFault(SOAPMessageContext context) {
     return true;
    };

    public void destroy() {
    };

    public void close(MessageContext context) {
    };

    public boolean handleMessage(SOAPMessageContext context)
    {
        System.out.println("HANDLER: R2739Handler.handleMessage() BEGIN");
        handle(context);
        System.out.println("HANDLER: R2739Handler.handleMessage() END");
        return true;
    }

    private void handle(MessageContext context) {
        try{
            addExtraHeader((SOAPMessageContext)context);
        }catch(SOAPException se){
            com.sun.ts.lib.util.TestUtil.printStackTrace(se);
        }
    }

    private void addExtraHeader(SOAPMessageContext context) throws SOAPException{
        SOAPEnvelope env = context.getMessage().getSOAPPart().getEnvelope();
        if(env.getHeader() == null){
            SOAPHeader header = env.addHeader();
            SOAPHeaderElement extraHeader = header.addHeaderElement(getExtraHeaderName(env));
            extraHeader.setActor("extra-header-actor");
            extraHeader.setMustUnderstand(true);
	    context.getMessage().saveChanges();
        }
    }

    private Name getExtraHeaderName(SOAPEnvelope env) throws SOAPException{
        return env.createName("extra-header", "ns1", "http://extra-header.org");
    }
}
