/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * @(#)Client.java	1.3	03/05/09
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R4001;

import java.nio.charset.Charset;
import java.util.Properties;

import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

import com.sun.javatest.Status;
import com.sun.ts.tests.jaxws.sharedclients.ClientFactory;
import com.sun.ts.tests.jaxws.wsi.requests.SOAPRequests;

import com.sun.ts.lib.harness.*;

public class Client extends ServiceEETest implements SOAPRequests{

    /**
     * The string to be echoed for request two.
     */        
    private static final String STRING_2 = "R4001-2";
         
    /**
     * The one client.
     */
    private W2JRLR4001ClientOne client1;
    
    static W2JRLR4001TestService service = null;
    
    /**
     * Test entry point.
     * 
     * @param args the command-line arguments.
     */
    public static void main(String[] args) {
        Client client = new Client();
        Status status = client.run(args, System.out, System.err);
        status.exit();
    }

    
    /**
     * @class.testArgs:     -ap jaxws-url-props.dat
     * @class.setup_props: webServerHost;
     *                     webServerPort;
     *                     platform.mode;
     *
     * @param args
     * @param properties
     *
     * @throws Fault
     */
    public void setup(String[] args, Properties properties) throws Fault {
        client1 = (W2JRLR4001ClientOne)ClientFactory.getClient(W2JRLR4001ClientOne.class, properties, this, service);
        logMsg("setup ok");
    }

    public void cleanup() {
        logMsg("cleanup");
    }

    /**
     * @testName: testRequestWithBOM
     *
     * @assertion_ids: WSI:SPEC:R4001
     *
     * @test_Strategy: A valid request, encoded in UTF-16 with a BOM, is sent to the
     * endpoint.  A conformant server must correctly process it and return the
     * expected response.
     *
     * @throws Fault
     */
    public void testRequestWithBOM() throws Fault {
        SOAPMessage response;
        try {
            Charset cs = Charset.forName("UTF-16");
            response = client1.makeSaajRequest(R4001_REQUEST, cs);
        } catch (Exception e) {
            throw new Fault("Unable to invoke echoString operation (BP-R4001)", e);
        }
        try {
            SOAPBody body = response.getSOAPPart().getEnvelope().getBody();
            if (body.hasFault()) {
                throw new Fault("Request not processed by endpoint (BP-R4001)");
            }
        } catch (SOAPException e) {
            throw new Fault("Invalid SOAP message returned (BP-R4001)", e);
        }
    }
    
}
