/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: W2JRLR4002Client.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R4002;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;

public class W2JRLR4002Client extends SOAPClient {
    public W2JRLR4002Client(String webServerHost, int webServerPort, int mode) throws EETest.Fault {
        this(webServerHost, webServerPort, mode, null);
    }

    public W2JRLR4002Client(String webServerHost, int webServerPort, int mode, javax.xml.ws.Service webServiceRef) throws EETest.Fault {
        super(webServerHost, webServerPort, mode);
        stubContext.setNamespace("http://w2jrlr4002testservice.org/W2JRLR4002TestService.wsdl");
        stubContext.setService("W2JRLR4002TestService");
        stubContext.setPort("W2JRLR4002TestPort");
        stubContext.setEndpointInterface(W2JRLR4002Test.class);
	stubContext.setWebServiceRef(webServiceRef);
    }

    protected String getEndpointURLProperty() {
        return "wsi.w2jrlr4002.endpoint.1";
    }

    protected String getWSDLURLProperty() {
        return "wsi.w2jrlr4002.wsdlloc.1";
    }

    public String echoString(String str) throws Exception {
        NonNullString nns = new NonNullString();
	nns.setP1(str);
        nns = ((W2JRLR4002Test)stubContext.getStub()).echoString(nns);
        return nns.getP1();
    }
}
