/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: WebLog.java 62592 2011-04-20 20:07:16Z kgrucci $
 */
 
package com.sun.ts.tests.common.webclient.log;

import org.apache.commons.logging.impl.SimpleLog;
import com.sun.ts.lib.util.TestUtil;

public class WebLog extends SimpleLog {

    /**
     * Construct a simple log with given name.
     *
     * @param name log name
     */
    public WebLog(String name) {
        super(name);
    }

    /**
     * <p> Do the actual logging.
     * This method assembles the message
     * and then prints to <code>System.err</code>.</p>
     */
    protected void log(int type, Object message, Throwable t) {
        StringBuffer buf = new StringBuffer(64);
        // append log type
        buf.append("[WIRE] - ");

        // append the message
        buf.append(String.valueOf(message));

        if (t == null) {
            TestUtil.logTrace(buf.toString());
        } else {
            TestUtil.logTrace(buf.toString(), t);
        }
    }
}
