/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $URL: https://adc4110351.us.oracle.com/svn/spider/branches/cts/8.0/src/com/sun/ts/tests/jstl/common/wrappers/FormatResponseWrapper.java $ $LastChangedDate: 2011-04-15 11:32:31 -0700 (Fri, 15 Apr 2011) $
 */

package com.sun.ts.tests.jstl.common.wrappers;

import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpServletResponse;
import java.util.Locale;

/*
 * This is a simple HttpResposneWrapper to "log" calls
 * to setLocale() made by specific I18N actions.
 */

public class FormatResponseWrapper extends HttpServletResponseWrapper{

    /** Creates new FormatResponseWrapper */
    public FormatResponseWrapper(HttpServletResponse response) {
        super(response);
    }

/* 
 * public methods
 * ========================================================================
 */
    
    /*
     * Sets the locale of the response. 
     *
     * @param locale the locale of the response
     */
    public void setLocale(Locale locale) {
        super.setHeader("setlocale", locale.toString());
        super.setLocale(locale);
    }  
    
    /*
     * Returns the name of the charset used for the MIME body sent in 
     * this reponse
     *
     * @return a String specifying the name of the charset, for example, 
     *         ISO-8859-1
     */
    public String getCharacterEncoding() {
        super.setHeader("charencoding", "called");
        return super.getCharacterEncoding();
    }
}
