/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.scinitializer.geteffectivesessiontrackingmodes;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class TestListener implements ServletContextListener {

    /**
     * Receives notification that the web application initialization
     * process is starting.
     *
     * @param sce The ServletContextEvent
     */
    public void contextInitialized(ServletContextEvent sce) {
        boolean passed = true;
        ServletContext context = sce.getServletContext();
        StringBuilder log = new StringBuilder();

        try {
            context.getEffectiveSessionTrackingModes();
            passed = false;
            log.append("Expected UnsupportedOperationException not thrown.");
        } catch (UnsupportedOperationException ex) {
            log.append("Expected UnsupportedOperationException thrown.");
        }

        context.setAttribute("TCK_TEST_STATUS", log.toString());
        context.setAttribute("TCK_TEST_PASS_STATUS", passed);
    }

    /**
     * Receives notification that the servlet context is about to be shut down.
     *
     * @param sce The servlet context event
     */
    public void contextDestroyed(ServletContextEvent sce) {
        // Do nothing
    }
}
