/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.servletrequest30;

import com.sun.ts.tests.servlet.common.servlets.GenericTCKServlet;
import java.io.IOException;
import javax.servlet.*;

public class TestServlet extends GenericTCKServlet {

    public void getServletContextTest(ServletRequest request,
            ServletResponse response)
            throws ServletException, IOException {

        ServletContext actual = request.getServletContext();
        ServletContext expected = this.getServletConfig().getServletContext();

        if (actual != expected) {
            response.getWriter().println("getServletContext() returned inconsistent result. Test FAILED.");
        } else {
            response.getWriter().println("Test PASSED.");
        }
    }

    public void getDispatcherTypeTestRequest(ServletRequest request,
            ServletResponse response)
            throws ServletException, IOException {

        response.getWriter().println("DispatcherType=" +
                request.getDispatcherType());
    }

    public void getDispatcherTypeTestForward(ServletRequest request,
            ServletResponse response)
            throws ServletException, IOException {

        String path = "/forward/ForwardedServlet?testname=getDispatcherTypeTest";
        RequestDispatcher rd = request.getRequestDispatcher(path);

        if (rd == null) {
            response.getWriter().println("Null RequestDispatcher got for path=" +
                    path);
        } else {
            rd.forward(request, response);
        }

    }

    public void getDispatcherTypeTestInclude(ServletRequest request,
            ServletResponse response)
            throws ServletException, IOException {

        String path = "/include/IncludedServlet?testname=getDispatcherTypeTest";
        RequestDispatcher rd = request.getRequestDispatcher(path);

        if (rd == null) {
            response.getWriter().println("Null RequestDispatcher got for path=" +
                    path);
        } else {
            rd.include(request, response);
        }
    }

    public void isAsyncSupportedTest(ServletRequest request,
            ServletResponse response) throws IOException {
        response.getWriter().println("isAsyncSupported=" +
                request.isAsyncSupported());
    }

    public void startAsyncTest(ServletRequest request,
            ServletResponse response) throws IOException {
        try {
            AsyncContext startAsync = request.startAsync();
            response.getWriter().println("Expected IllegalStateException not thrown. Test FAILED.");
        } catch (IllegalStateException ise) {
            response.getWriter().println("Expected IllegalStateException thrown. Test PASSED.");
        }
    }
}
