/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.panes;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.WritableIntegerValue;
import javafx.scene.Node;
import org.eclipse.fx.ui.panes.AbstractLayoutPane;
import org.eclipse.fx.ui.panes.GridData;

public class GridLayoutPane
extends AbstractLayoutPane<GridData> {
    private IntegerProperty numColumns = new SimpleIntegerProperty((Object)this, "columns", 1);
    private BooleanProperty makeColumnsEqualWidth = new SimpleBooleanProperty((Object)this, "makeColumnsEqualWidth", false);
    private IntegerProperty marginWidth = new SimpleIntegerProperty((Object)this, "marginWidth", 5);
    private IntegerProperty marginHeight = new SimpleIntegerProperty((Object)this, "marginHeight", 5);
    private IntegerProperty marginLeft = new SimpleIntegerProperty((Object)this, "marginLeft", 0);
    private IntegerProperty marginTop = new SimpleIntegerProperty((Object)this, "marginTop", 0);
    private IntegerProperty marginRight = new SimpleIntegerProperty((Object)this, "marginRight", 0);
    private IntegerProperty marginBottom = new SimpleIntegerProperty((Object)this, "marginBottom", 0);
    private IntegerProperty horizontalSpacing = new SimpleIntegerProperty((Object)this, "horizontalSpacing", 5);
    private IntegerProperty verticalSpacing = new SimpleIntegerProperty((Object)this, "verticalSpacing", 5);

    public static void setConstraint(Node n, GridData griddata) {
        GridLayoutPane.setConstraint(n, "gd", griddata);
    }

    public static GridData getConstraint(Node n) {
        return (GridData)GridLayoutPane.getConstraint(n, "gd");
    }

    @Override
    protected AbstractLayoutPane.Size computeSize(double width, double height, boolean flushCache) {
        return this.calculateLayout(false, 0.0, 0.0, width, height, flushCache);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.calculateLayout(true, this.getLayoutBounds().getMinX(), this.getLayoutBounds().getMinY(), this.getLayoutBounds().getWidth(), this.getLayoutBounds().getHeight(), true);
    }

    private AbstractLayoutPane.Size calculateLayout(boolean move, double x, double y, double width, double height, boolean flushCache) {
        int i;
        int i2;
        GridData data;
        if (this.numColumns.get() < 1) {
            return new AbstractLayoutPane.Size(this.marginLeft.get() + this.marginWidth.get() * 2 + this.marginRight.get(), this.marginTop.get() + this.marginHeight.get() * 2 + this.marginBottom.get());
        }
        Node[] children = (Node[])this.getChildren().toArray((Object[])new Node[0]);
        int count = 0;
        int i3 = 0;
        while (i3 < children.length) {
            Node control = children[i3];
            data = (GridData)GridLayoutPane.getConstraint(control, "gd");
            if (data == null || !data.exclude.get()) {
                children[count++] = children[i3];
            }
            ++i3;
        }
        if (count == 0) {
            return new AbstractLayoutPane.Size(this.marginLeft.get() + this.marginWidth.get() * 2 + this.marginRight.get(), this.marginTop.get() + this.marginHeight.get() * 2 + this.marginBottom.get());
        }
        i3 = 0;
        while (i3 < count) {
            Node child = children[i3];
            data = (GridData)GridLayoutPane.getConstraint(child, "gd");
            if (data == null) {
                data = new GridData();
                GridLayoutPane.setConstraint(child, "gd", data);
            }
            if (flushCache) {
                data.flushCache();
            }
            data.computeSize(child, data.widthHint.get(), data.heightHint.get(), flushCache);
            if (data.grabExcessHorizontalSpace.get() && data.minimumWidth.get() > 0 && data.cacheWidth < (double)data.minimumWidth.get()) {
                int trim = 0;
                data.cacheHeight = -1.0;
                data.cacheWidth = -1.0;
                data.computeSize(child, Math.max(0, data.minimumWidth.get() - trim), data.heightHint.get(), false);
            }
            if (data.grabExcessVerticalSpace.get() && data.minimumHeight.get() > 0) {
                data.cacheHeight = Math.max(data.cacheHeight, (double)data.minimumHeight.get());
            }
            ++i3;
        }
        int row = 0;
        int column = 0;
        int rowCount = 0;
        int columnCount = this.numColumns.get();
        Node[][] grid = new Node[4][columnCount];
        int i4 = 0;
        while (i4 < count) {
            Node child = children[i4];
            GridData data2 = (GridData)GridLayoutPane.getConstraint(child, "gd");
            int hSpan = Math.max(1, Math.min(data2.horizontalSpan.get(), columnCount));
            int vSpan = Math.max(1, data2.verticalSpan.get());
            while (true) {
                int lastRow;
                if ((lastRow = row + vSpan) >= grid.length) {
                    Node[][] newGrid = new Node[lastRow + 4][columnCount];
                    System.arraycopy(grid, 0, newGrid, 0, grid.length);
                    grid = newGrid;
                }
                if (grid[row] == null) {
                    grid[row] = new Node[columnCount];
                }
                while (column < columnCount && grid[row][column] != null) {
                    ++column;
                }
                int endCount = column + hSpan;
                if (endCount <= columnCount) {
                    int index = column;
                    while (index < endCount && grid[row][index] == null) {
                        ++index;
                    }
                    if (index == endCount) break;
                    column = index;
                }
                if (column + hSpan < columnCount) continue;
                column = 0;
                ++row;
            }
            int j = 0;
            while (j < vSpan) {
                if (grid[row + j] == null) {
                    grid[row + j] = new Node[columnCount];
                }
                int k = 0;
                while (k < hSpan) {
                    grid[row + j][column + k] = child;
                    ++k;
                }
                ++j;
            }
            rowCount = Math.max(rowCount, row + vSpan);
            column += hSpan;
            ++i4;
        }
        double availableWidth = width - (double)(this.horizontalSpacing.get() * (columnCount - 1)) - (double)(this.marginLeft.get() + this.marginWidth.get() * 2 + this.marginRight.get());
        int expandCount = 0;
        double[] widths = new double[columnCount];
        double[] minWidths = new double[columnCount];
        boolean[] expandColumn = new boolean[columnCount];
        int j = 0;
        while (j < columnCount) {
            int hSpan;
            GridData data3;
            i2 = 0;
            while (i2 < rowCount) {
                data3 = this.getData(grid, i2, j, rowCount, columnCount, true);
                if (data3 != null && (hSpan = Math.max(1, Math.min(data3.horizontalSpan.get(), columnCount))) == 1) {
                    double w = data3.cacheWidth + (double)data3.horizontalIndent.get();
                    widths[j] = Math.max(widths[j], w);
                    if (data3.grabExcessHorizontalSpace.get()) {
                        if (!expandColumn[j]) {
                            ++expandCount;
                        }
                        expandColumn[j] = true;
                    }
                    if (!data3.grabExcessHorizontalSpace.get() || data3.minimumWidth.get() != 0) {
                        w = !data3.grabExcessHorizontalSpace.get() || data3.minimumWidth.get() == -1 ? data3.cacheWidth : (double)data3.minimumWidth.get();
                        minWidths[j] = Math.max(minWidths[j], w += (double)data3.horizontalIndent.get());
                    }
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < rowCount) {
                data3 = this.getData(grid, i2, j, rowCount, columnCount, false);
                if (data3 != null && (hSpan = Math.max(1, Math.min(data3.horizontalSpan.get(), columnCount))) > 1) {
                    double delta;
                    int k;
                    int last;
                    double remainder;
                    double w;
                    int spanWidth = 0;
                    int spanMinWidth = 0;
                    int spanExpandCount = 0;
                    int k2 = 0;
                    while (k2 < hSpan) {
                        spanWidth = (int)((double)spanWidth + widths[j - k2]);
                        spanMinWidth = (int)((double)spanMinWidth + minWidths[j - k2]);
                        if (expandColumn[j - k2]) {
                            ++spanExpandCount;
                        }
                        ++k2;
                    }
                    if (data3.grabExcessHorizontalSpace.get() && spanExpandCount == 0) {
                        ++expandCount;
                        expandColumn[j] = true;
                    }
                    if ((w = data3.cacheWidth + (double)data3.horizontalIndent.get() - (double)spanWidth - (double)((hSpan - 1) * this.horizontalSpacing.get())) > 0.0) {
                        if (this.makeColumnsEqualWidth.get()) {
                            double equalWidth = (w + (double)spanWidth) / (double)hSpan;
                            remainder = (w + (double)spanWidth) % (double)hSpan;
                            last = -1;
                            k = 0;
                            while (k < hSpan) {
                                last = j - k;
                                widths[last] = Math.max(equalWidth, widths[j - k]);
                                ++k;
                            }
                            if (last > -1) {
                                int n = last;
                                widths[n] = widths[n] + remainder;
                            }
                        } else if (spanExpandCount == 0) {
                            int n = j;
                            widths[n] = widths[n] + w;
                        } else {
                            delta = w / (double)spanExpandCount;
                            remainder = w % (double)spanExpandCount;
                            last = -1;
                            k = 0;
                            while (k < hSpan) {
                                if (expandColumn[j - k]) {
                                    last = j - k;
                                    widths[last] = widths[last] + delta;
                                }
                                ++k;
                            }
                            if (last > -1) {
                                int n = last;
                                widths[n] = widths[n] + remainder;
                            }
                        }
                    }
                    if (!data3.grabExcessHorizontalSpace.get() || data3.minimumWidth.get() != 0) {
                        w = !data3.grabExcessHorizontalSpace.get() || data3.minimumWidth.get() == -1 ? data3.cacheWidth : (double)data3.minimumWidth.get();
                        if ((w += (double)(data3.horizontalIndent.get() - spanMinWidth - (hSpan - 1) * this.horizontalSpacing.get())) > 0.0) {
                            if (spanExpandCount == 0) {
                                int n = j;
                                minWidths[n] = minWidths[n] + w;
                            } else {
                                delta = w / (double)spanExpandCount;
                                remainder = w % (double)spanExpandCount;
                                last = -1;
                                k = 0;
                                while (k < hSpan) {
                                    if (expandColumn[j - k]) {
                                        last = j - k;
                                        minWidths[last] = minWidths[last] + delta;
                                    }
                                    ++k;
                                }
                                if (last > -1) {
                                    int n = last;
                                    minWidths[n] = minWidths[n] + remainder;
                                }
                            }
                        }
                    }
                }
                ++i2;
            }
            ++j;
        }
        if (this.makeColumnsEqualWidth.get()) {
            double minColumnWidth = 0.0;
            double columnWidth = 0.0;
            int i5 = 0;
            while (i5 < columnCount) {
                minColumnWidth = Math.max(minColumnWidth, minWidths[i5]);
                columnWidth = Math.max(columnWidth, widths[i5]);
                ++i5;
            }
            columnWidth = width == -1.0 || expandCount == 0 ? columnWidth : Math.max(minColumnWidth, availableWidth / (double)columnCount);
            i5 = 0;
            while (i5 < columnCount) {
                expandColumn[i5] = expandCount > 0;
                widths[i5] = columnWidth;
                ++i5;
            }
        } else if (width != -1.0 && expandCount > 0) {
            int totalWidth = 0;
            i2 = 0;
            while (i2 < columnCount) {
                totalWidth = (int)((double)totalWidth + widths[i2]);
                ++i2;
            }
            int c = expandCount;
            double delta = (availableWidth - (double)totalWidth) / (double)c;
            double remainder = (availableWidth - (double)totalWidth) % (double)c;
            int last = -1;
            while ((double)totalWidth != availableWidth) {
                int j2 = 0;
                while (j2 < columnCount) {
                    if (expandColumn[j2]) {
                        if (widths[j2] + delta > minWidths[j2]) {
                            last = j2;
                            widths[last] = widths[j2] + delta;
                        } else {
                            widths[j2] = minWidths[j2];
                            expandColumn[j2] = false;
                            --c;
                        }
                    }
                    ++j2;
                }
                if (last > -1) {
                    int n = last;
                    widths[n] = widths[n] + remainder;
                }
                j2 = 0;
                while (j2 < columnCount) {
                    i = 0;
                    while (i < rowCount) {
                        int hSpan;
                        GridData data4 = this.getData(grid, i, j2, rowCount, columnCount, false);
                        if (!(data4 == null || (hSpan = Math.max(1, Math.min(data4.horizontalSpan.get(), columnCount))) <= 1 || data4.grabExcessHorizontalSpace.get() && data4.minimumWidth.get() == 0)) {
                            int spanWidth = 0;
                            int spanExpandCount = 0;
                            int k = 0;
                            while (k < hSpan) {
                                spanWidth = (int)((double)spanWidth + widths[j2 - k]);
                                if (expandColumn[j2 - k]) {
                                    ++spanExpandCount;
                                }
                                ++k;
                            }
                            double w = !data4.grabExcessHorizontalSpace.get() || data4.minimumWidth.get() == -1 ? data4.cacheWidth : (double)data4.minimumWidth.get();
                            if ((w += (double)(data4.horizontalIndent.get() - spanWidth - (hSpan - 1) * this.horizontalSpacing.get())) > 0.0) {
                                if (spanExpandCount == 0) {
                                    int n = j2;
                                    widths[n] = widths[n] + w;
                                } else {
                                    double delta2 = w / (double)spanExpandCount;
                                    double remainder2 = w % (double)spanExpandCount;
                                    int last2 = -1;
                                    int k3 = 0;
                                    while (k3 < hSpan) {
                                        if (expandColumn[j2 - k3]) {
                                            last2 = j2 - k3;
                                            widths[last2] = widths[last2] + delta2;
                                        }
                                        ++k3;
                                    }
                                    if (last2 > -1) {
                                        int n = last2;
                                        widths[n] = widths[n] + remainder2;
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                    ++j2;
                }
                if (c != 0) {
                    totalWidth = 0;
                    int i6 = 0;
                    while (i6 < columnCount) {
                        totalWidth = (int)((double)totalWidth + widths[i6]);
                        ++i6;
                    }
                    delta = (availableWidth - (double)totalWidth) / (double)c;
                    remainder = (availableWidth - (double)totalWidth) % (double)c;
                    last = -1;
                    continue;
                }
                break;
            }
        }
        GridData[] flush = null;
        int flushLength = 0;
        if (width != -1.0) {
            int j3 = 0;
            while (j3 < columnCount) {
                int i7 = 0;
                while (i7 < rowCount) {
                    GridData data5 = this.getData(grid, i7, j3, rowCount, columnCount, false);
                    if (data5 != null && data5.heightHint.get() == -1) {
                        Node child = grid[i7][j3];
                        int hSpan = Math.max(1, Math.min(data5.horizontalSpan.get(), columnCount));
                        int currentWidth = 0;
                        int k = 0;
                        while (k < hSpan) {
                            currentWidth = (int)((double)currentWidth + widths[j3 - k]);
                            ++k;
                        }
                        if ((double)(currentWidth += (hSpan - 1) * this.horizontalSpacing.get() - data5.horizontalIndent.get()) != data5.cacheWidth && data5.horizontalAlignment.get() == GridData.Alignment.FILL || data5.cacheWidth > (double)currentWidth) {
                            int trim = 0;
                            data5.cacheHeight = -1.0;
                            data5.cacheWidth = -1.0;
                            data5.computeSize(child, Math.max(0, currentWidth - trim), data5.heightHint.get(), false);
                            if (data5.grabExcessVerticalSpace.get() && data5.minimumHeight.get() > 0) {
                                data5.cacheHeight = Math.max(data5.cacheHeight, (double)data5.minimumHeight.get());
                            }
                            if (flush == null) {
                                flush = new GridData[count];
                            }
                            flush[flushLength++] = data5;
                        }
                    }
                    ++i7;
                }
                ++j3;
            }
        }
        double availableHeight = height - (double)(this.verticalSpacing.get() * (rowCount - 1)) - (double)(this.marginTop.get() + this.marginHeight.get() * 2 + this.marginBottom.get());
        expandCount = 0;
        double[] heights = new double[rowCount];
        double[] minHeights = new double[rowCount];
        boolean[] expandRow = new boolean[rowCount];
        int i8 = 0;
        while (i8 < rowCount) {
            int vSpan;
            int j4 = 0;
            while (j4 < columnCount) {
                GridData data6 = this.getData(grid, i8, j4, rowCount, columnCount, true);
                if (data6 != null && (vSpan = Math.max(1, Math.min(data6.verticalSpan.get(), rowCount))) == 1) {
                    double h = data6.cacheHeight + (double)data6.verticalIndent.get();
                    heights[i8] = Math.max(heights[i8], h);
                    if (data6.grabExcessVerticalSpace.get()) {
                        if (!expandRow[i8]) {
                            ++expandCount;
                        }
                        expandRow[i8] = true;
                    }
                    if (!data6.grabExcessVerticalSpace.get() || data6.minimumHeight.get() != 0) {
                        h = !data6.grabExcessVerticalSpace.get() || data6.minimumHeight.get() == -1 ? data6.cacheHeight : (double)data6.minimumHeight.get();
                        minHeights[i8] = Math.max(minHeights[i8], h += (double)data6.verticalIndent.get());
                    }
                }
                ++j4;
            }
            j4 = 0;
            while (j4 < columnCount) {
                GridData data7 = this.getData(grid, i8, j4, rowCount, columnCount, false);
                if (data7 != null && (vSpan = Math.max(1, Math.min(data7.verticalSpan.get(), rowCount))) > 1) {
                    int k;
                    int last;
                    double remainder;
                    double delta;
                    double h;
                    int spanHeight = 0;
                    int spanMinHeight = 0;
                    int spanExpandCount = 0;
                    int k4 = 0;
                    while (k4 < vSpan) {
                        spanHeight = (int)((double)spanHeight + heights[i8 - k4]);
                        spanMinHeight = (int)((double)spanMinHeight + minHeights[i8 - k4]);
                        if (expandRow[i8 - k4]) {
                            ++spanExpandCount;
                        }
                        ++k4;
                    }
                    if (data7.grabExcessVerticalSpace.get() && spanExpandCount == 0) {
                        ++expandCount;
                        expandRow[i8] = true;
                    }
                    if ((h = data7.cacheHeight + (double)data7.verticalIndent.get() - (double)spanHeight - (double)((vSpan - 1) * this.verticalSpacing.get())) > 0.0) {
                        if (spanExpandCount == 0) {
                            int n = i8;
                            heights[n] = heights[n] + h;
                        } else {
                            delta = h / (double)spanExpandCount;
                            remainder = h % (double)spanExpandCount;
                            last = -1;
                            k = 0;
                            while (k < vSpan) {
                                if (expandRow[i8 - k]) {
                                    last = i8 - k;
                                    heights[last] = heights[last] + delta;
                                }
                                ++k;
                            }
                            if (last > -1) {
                                int n = last;
                                heights[n] = heights[n] + remainder;
                            }
                        }
                    }
                    if (!data7.grabExcessVerticalSpace.get() || data7.minimumHeight.get() != 0) {
                        h = !data7.grabExcessVerticalSpace.get() || data7.minimumHeight.get() == -1 ? data7.cacheHeight : (double)data7.minimumHeight.get();
                        if ((h += (double)(data7.verticalIndent.get() - spanMinHeight - (vSpan - 1) * this.verticalSpacing.get())) > 0.0) {
                            if (spanExpandCount == 0) {
                                int n = i8;
                                minHeights[n] = minHeights[n] + h;
                            } else {
                                delta = h / (double)spanExpandCount;
                                remainder = h % (double)spanExpandCount;
                                last = -1;
                                k = 0;
                                while (k < vSpan) {
                                    if (expandRow[i8 - k]) {
                                        last = i8 - k;
                                        minHeights[last] = minHeights[last] + delta;
                                    }
                                    ++k;
                                }
                                if (last > -1) {
                                    int n = last;
                                    minHeights[n] = minHeights[n] + remainder;
                                }
                            }
                        }
                    }
                }
                ++j4;
            }
            ++i8;
        }
        if (height != -1.0 && expandCount > 0) {
            int totalHeight = 0;
            i = 0;
            while (i < rowCount) {
                totalHeight = (int)((double)totalHeight + heights[i]);
                ++i;
            }
            int c = expandCount;
            double delta = (availableHeight - (double)totalHeight) / (double)c;
            double remainder = (availableHeight - (double)totalHeight) % (double)c;
            int last = -1;
            while ((double)totalHeight != availableHeight) {
                int i9 = 0;
                while (i9 < rowCount) {
                    if (expandRow[i9]) {
                        if (heights[i9] + delta > minHeights[i9]) {
                            last = i9;
                            heights[last] = heights[i9] + delta;
                        } else {
                            heights[i9] = minHeights[i9];
                            expandRow[i9] = false;
                            --c;
                        }
                    }
                    ++i9;
                }
                if (last > -1) {
                    int n = last;
                    heights[n] = heights[n] + remainder;
                }
                i9 = 0;
                while (i9 < rowCount) {
                    int j5 = 0;
                    while (j5 < columnCount) {
                        int vSpan;
                        GridData data8 = this.getData(grid, i9, j5, rowCount, columnCount, false);
                        if (!(data8 == null || (vSpan = Math.max(1, Math.min(data8.verticalSpan.get(), rowCount))) <= 1 || data8.grabExcessVerticalSpace.get() && data8.minimumHeight.get() == 0)) {
                            int spanHeight = 0;
                            int spanExpandCount = 0;
                            int k = 0;
                            while (k < vSpan) {
                                spanHeight = (int)((double)spanHeight + heights[i9 - k]);
                                if (expandRow[i9 - k]) {
                                    ++spanExpandCount;
                                }
                                ++k;
                            }
                            double h = !data8.grabExcessVerticalSpace.get() || data8.minimumHeight.get() == -1 ? data8.cacheHeight : (double)data8.minimumHeight.get();
                            if ((h += (double)(data8.verticalIndent.get() - spanHeight - (vSpan - 1) * this.verticalSpacing.get())) > 0.0) {
                                if (spanExpandCount == 0) {
                                    int n = i9;
                                    heights[n] = heights[n] + h;
                                } else {
                                    double delta2 = h / (double)spanExpandCount;
                                    double remainder2 = h % (double)spanExpandCount;
                                    int last2 = -1;
                                    int k5 = 0;
                                    while (k5 < vSpan) {
                                        if (expandRow[i9 - k5]) {
                                            last2 = i9 - k5;
                                            heights[last2] = heights[last2] + delta2;
                                        }
                                        ++k5;
                                    }
                                    if (last2 > -1) {
                                        int n = last2;
                                        heights[n] = heights[n] + remainder2;
                                    }
                                }
                            }
                        }
                        ++j5;
                    }
                    ++i9;
                }
                if (c == 0) break;
                totalHeight = 0;
                i9 = 0;
                while (i9 < rowCount) {
                    totalHeight = (int)((double)totalHeight + heights[i9]);
                    ++i9;
                }
                delta = (availableHeight - (double)totalHeight) / (double)c;
                remainder = (availableHeight - (double)totalHeight) % (double)c;
                last = -1;
            }
        }
        if (move) {
            double gridY = y + (double)this.marginTop.get() + (double)this.marginHeight.get();
            int i10 = 0;
            while (i10 < rowCount) {
                double gridX = x + (double)this.marginLeft.get() + (double)this.marginWidth.get();
                int j6 = 0;
                while (j6 < columnCount) {
                    GridData data9 = this.getData(grid, i10, j6, rowCount, columnCount, true);
                    if (data9 != null) {
                        int hSpan = Math.max(1, Math.min(data9.horizontalSpan.get(), columnCount));
                        int vSpan = Math.max(1, data9.verticalSpan.get());
                        int cellWidth = 0;
                        int cellHeight = 0;
                        int k = 0;
                        while (k < hSpan) {
                            cellWidth = (int)((double)cellWidth + widths[j6 + k]);
                            ++k;
                        }
                        k = 0;
                        while (k < vSpan) {
                            cellHeight = (int)((double)cellHeight + heights[i10 + k]);
                            ++k;
                        }
                        double childX = gridX + (double)data9.horizontalIndent.get();
                        double childWidth = Math.min(data9.cacheWidth, (double)(cellWidth += this.horizontalSpacing.get() * (hSpan - 1)));
                        switch ((GridData.Alignment)((Object)data9.horizontalAlignment.get())) {
                            case CENTER: {
                                childX += Math.max(0.0, ((double)(cellWidth - data9.horizontalIndent.get()) - childWidth) / 2.0);
                                break;
                            }
                            case END: {
                                childX += Math.max(0.0, (double)(cellWidth - data9.horizontalIndent.get()) - childWidth);
                                break;
                            }
                            case FILL: {
                                childWidth = cellWidth - data9.horizontalIndent.get();
                                break;
                            }
                        }
                        double childY = gridY + (double)data9.verticalIndent.get();
                        double childHeight = Math.min(data9.cacheHeight, (double)(cellHeight += this.verticalSpacing.get() * (vSpan - 1)));
                        switch ((GridData.Alignment)((Object)data9.verticalAlignment.get())) {
                            case CENTER: {
                                childY += Math.max(0.0, ((double)(cellHeight - data9.verticalIndent.get()) - childHeight) / 2.0);
                                break;
                            }
                            case END: {
                                childY += Math.max(0.0, (double)(cellHeight - data9.verticalIndent.get()) - childHeight);
                                break;
                            }
                            case FILL: {
                                childHeight = cellHeight - data9.verticalIndent.get();
                                break;
                            }
                        }
                        Node child = grid[i10][j6];
                        if (child != null) {
                            child.resizeRelocate(childX, childY, childWidth, childHeight);
                        }
                    }
                    gridX += widths[j6] + (double)this.horizontalSpacing.get();
                    ++j6;
                }
                gridY += heights[i10] + (double)this.verticalSpacing.get();
                ++i10;
            }
        }
        i = 0;
        while (i < flushLength) {
            if (flush != null) {
                flush[i].cacheHeight = -1.0;
                flush[i].cacheWidth = -1.0;
            }
            ++i;
        }
        int totalDefaultWidth = 0;
        int totalDefaultHeight = 0;
        int i11 = 0;
        while (i11 < columnCount) {
            totalDefaultWidth = (int)((double)totalDefaultWidth + widths[i11]);
            ++i11;
        }
        i11 = 0;
        while (i11 < rowCount) {
            totalDefaultHeight = (int)((double)totalDefaultHeight + heights[i11]);
            ++i11;
        }
        return new AbstractLayoutPane.Size(totalDefaultWidth += this.horizontalSpacing.get() * (columnCount - 1) + this.marginLeft.get() + this.marginWidth.get() * 2 + this.marginRight.get(), totalDefaultHeight += this.verticalSpacing.get() * (rowCount - 1) + this.marginTop.get() + this.marginHeight.get() * 2 + this.marginBottom.get());
    }

    GridData getData(Node[][] grid, int row, int column, int rowCount, int columnCount, boolean first) {
        Node control = grid[row][column];
        if (control != null) {
            int j;
            GridData data = (GridData)GridLayoutPane.getConstraint(control, "gd");
            int hSpan = Math.max(1, Math.min(data.horizontalSpan.get(), columnCount));
            int vSpan = Math.max(1, data.verticalSpan.get());
            int i = first ? row + vSpan - 1 : row - vSpan + 1;
            int n = j = first ? column + hSpan - 1 : column - hSpan + 1;
            if (i >= 0 && i < rowCount && j >= 0 && j < columnCount && control == grid[i][j]) {
                return data;
            }
        }
        return null;
    }

    public void setNumColumns(int numColumns) {
        this.numColumns.set(numColumns);
    }

    public int getNumColumns() {
        return this.numColumns.get();
    }

    public WritableIntegerValue numColumnsProperty() {
        return this.numColumns;
    }

    public void setMakeColumnsEqualWidth(boolean makeColumnsEqualWidth) {
        this.makeColumnsEqualWidth.set(makeColumnsEqualWidth);
    }

    public boolean isMakeColumnsEqualWidth() {
        return this.makeColumnsEqualWidth.get();
    }

    public BooleanProperty makeColumnsEqualWidthProperty() {
        return this.makeColumnsEqualWidth;
    }

    public void setHorizontalSpacing(int value) {
        this.horizontalSpacing.set(value);
    }

    public void getHorizontalSpacing() {
        this.horizontalSpacing.get();
    }

    public IntegerProperty horizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setMarginWidth(int value) {
        this.marginWidth.set(value);
    }

    public int getMarginWidth() {
        return this.marginWidth.get();
    }

    public IntegerProperty getMarginWidthProperty() {
        return this.marginWidth;
    }

    public void setMarginHeight(int value) {
        this.marginHeight.set(value);
    }

    public int getMarginHeight() {
        return this.marginHeight.get();
    }

    public IntegerProperty getMarginHeightProperty() {
        return this.marginHeight;
    }

    public void setMarginLeft(int value) {
        this.marginLeft.set(value);
    }

    public int getMarginLeft() {
        return this.marginLeft.get();
    }

    public IntegerProperty getMarginLeftProperty() {
        return this.marginLeft;
    }

    public void setMarginTop(int value) {
        this.marginTop.set(value);
    }

    public int getMarginTop() {
        return this.marginTop.get();
    }

    public IntegerProperty getMarginTopProperty() {
        return this.marginTop;
    }

    public void setMarginRight(int value) {
        this.marginRight.set(value);
    }

    public int getMarginRight() {
        return this.marginRight.get();
    }

    public IntegerProperty getMarginRightProperty() {
        return this.marginRight;
    }

    public void setMarginBottom(int value) {
        this.marginBottom.set(value);
    }

    public int getMarginBottom() {
        return this.marginBottom.get();
    }

    public IntegerProperty getMarginBottomProperty() {
        return this.marginBottom;
    }

    public void setVerticalSpacing(int value) {
        this.verticalSpacing.set(value);
    }

    public int getVerticalSpacing() {
        return this.verticalSpacing.get();
    }

    public IntegerProperty getVerticalSpacingProperty() {
        return this.verticalSpacing;
    }
}

