/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Camera;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.core.services.translation.TranslationService;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindowElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.di.InjectingFXMLLoader;
import org.eclipse.fx.ui.dialogs.Dialog;
import org.eclipse.fx.ui.dialogs.MessageDialog;
import org.eclipse.fx.ui.panes.FillLayoutPane;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.services.theme.Theme;
import org.eclipse.fx.ui.services.theme.ThemeManager;
import org.eclipse.fx.ui.workbench.fx.EMFUri;
import org.eclipse.fx.ui.workbench.fx.key.KeyBindingDispatcher;
import org.eclipse.fx.ui.workbench.renderers.base.BaseWindowRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.services.WindowTransitionService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCallback;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWindow;
import org.eclipse.fx.ui.workbench.renderers.fx.internal.Messages;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WLayoutedWidgetImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osgi.service.localization.BundleLocalization;
import org.osgi.framework.Bundle;

public class DefWindowRenderer
extends BaseWindowRenderer<Stage> {
    private static final String CSS_TRIM_CONTAINER = "window-trim-container";
    private static final String CSS_CONTENT_CONTAINER = "window-content-container";
    @Inject
    @Translation
    @NonNull Messages messages;

    protected @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ISaveHandler.Save> promptToSave(@NonNull MWindow element, @NonNull Collection<MPart> dirtyParts, @NonNull WWindow<Stage> widget) {
        Object[] response = new ISaveHandler.Save[dirtyParts.size()];
        IEclipseContext modelContext = this.getModelContext((MUIElement)element);
        if (modelContext == null) {
            this.getLogger().error("Model context should not be null at this point");
            Arrays.fill(response, ISaveHandler.Save.CANCEL);
            return Arrays.asList(response);
        }
        GraphicsLoader graphicsLoader = (GraphicsLoader)modelContext.get(GraphicsLoader.class);
        MultiMessageDialog d = new MultiMessageDialog((Window)((Stage)widget.getWidget()), dirtyParts, graphicsLoader);
        if (d.open() == 1) {
            List<MPart> parts = d.getSelectedParts();
            Arrays.fill(response, ISaveHandler.Save.NO);
            for (MPart p : parts) {
                response[parts.indexOf((Object)p)] = ISaveHandler.Save.YES;
            }
        } else {
            Arrays.fill(response, ISaveHandler.Save.CANCEL);
        }
        return Arrays.asList(response);
    }

    protected ISaveHandler.Save promptToSave(MWindow element, MPart dirtyPart, WWindow<Stage> widget) {
        MessageDialog.QuestionCancelResult r = MessageDialog.openQuestionCancelDialog((Window)((Stage)widget.getWidget()), (String)this.messages.DefWindowRenderer_promptToSave_Title, (String)this.messages.DefWindowRenderer_promptToSave_Message(dirtyPart.getLocalizedLabel()));
        switch (r) {
            case CANCEL: {
                return ISaveHandler.Save.CANCEL;
            }
            case NO: {
                return ISaveHandler.Save.NO;
            }
            case YES: {
                return ISaveHandler.Save.YES;
            }
        }
        return ISaveHandler.Save.CANCEL;
    }

    protected Class<? extends WWindow<Stage>> getWidgetClass(MWindow window) {
        return WWindowImpl.class;
    }

    public static interface CustomRootContainer {
        public void setTrim(Node var1);

        public void setMenuBar(Node var1);

        public void setTitle(String var1);
    }

    class MultiMessageDialog
    extends Dialog {
        private Collection<MPart> parts;
        TableView<Row> tabView;
        GraphicsLoader graphicsLoader;
        private List<MPart> selectedParts;

        public MultiMessageDialog(Window parent, Collection<MPart> parts, GraphicsLoader graphicsLoader) {
            super(parent, DefWindowRenderer.this.messages.DefWindowRenderer_MultiMessageDialog_Title);
            this.parts = parts;
            this.graphicsLoader = graphicsLoader;
        }

        public List<MPart> getSelectedParts() {
            return this.selectedParts;
        }

        protected void okPressed() {
            this.selectedParts = new ArrayList<MPart>();
            for (Row r : this.tabView.getItems()) {
                if (!r.isSelected()) continue;
                this.selectedParts.add((MPart)r.element.get());
            }
            super.okPressed();
        }

        protected Node createDialogArea() {
            BorderPane p = new BorderPane();
            Label l = new Label(DefWindowRenderer.this.messages.DefWindowRenderer_MultiMessageDialog_Message);
            p.setTop((Node)l);
            this.tabView = new TableView();
            TableColumn column = new TableColumn();
            column.setCellFactory(this::createCheckboxCell);
            column.setOnEditCommit(event -> ((Row)event.getRowValue()).selected.set(((Boolean)event.getNewValue()).booleanValue()));
            column.setCellValueFactory((Callback)new PropertyValueFactory("selected"));
            this.tabView.getColumns().add((Object)column);
            column = new TableColumn();
            column.setCellFactory(this::createTextCell);
            column.setCellValueFactory((Callback)new PropertyValueFactory("element"));
            this.tabView.getColumns().add((Object)column);
            this.tabView.setEditable(true);
            ArrayList<Row> list = new ArrayList<Row>();
            for (MPart m : this.parts) {
                list.add(new Row(m));
            }
            this.tabView.setItems(FXCollections.observableArrayList(list));
            p.setCenter(this.tabView);
            return p;
        }

        TableCell<Row, Boolean> createCheckboxCell(final TableColumn<Row, Boolean> param) {
            final CheckBox checkBox = new CheckBox();
            TableCell<Row, Boolean> cell = new TableCell<Row, Boolean>(){

                protected void updateItem(Boolean item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (item == null) {
                        checkBox.setDisable(true);
                        checkBox.setSelected(false);
                        checkBox.setOnAction(null);
                    } else {
                        checkBox.setDisable(false);
                        checkBox.setSelected(item.booleanValue());
                        checkBox.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                            public void handle(ActionEvent event) {
                                (this).MultiMessageDialog.this.tabView.edit(0, param);
                                this.commitEdit(checkBox.isSelected());
                            }
                        });
                    }
                }
            };
            cell.setGraphic((Node)checkBox);
            return cell;
        }

        TableCell<Row, MPart> createTextCell(TableColumn<Row, MPart> param) {
            return new TableCell<Row, MPart>(){

                protected void updateItem(MPart item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (item != null) {
                        this.setText(item.getLocalizedLabel());
                        String uri = item.getIconURI();
                        if (uri != null) {
                            this.setGraphic(MultiMessageDialog.this.graphicsLoader.getGraphicsNode((org.eclipse.fx.core.URI)new EMFUri(URI.createURI((String)uri))));
                        }
                    }
                }
            };
        }
    }

    static class Row {
        BooleanProperty selected = new SimpleBooleanProperty((Object)this, "selected", true);
        ObjectProperty<MPart> element = new SimpleObjectProperty((Object)this, "element");

        public Row(MPart element) {
            this.element.set((Object)element);
        }

        public boolean isSelected() {
            return this.selected.get();
        }

        public void setSelected(boolean value) {
            this.selected.set(value);
        }

        public BooleanProperty selectedProperty() {
            return this.selected;
        }

        public MPart getElement() {
            return (MPart)this.element.get();
        }

        public void setElement(MPart value) {
            this.element.set((Object)value);
        }

        public ObjectProperty<MPart> elementProperty() {
            return this.element;
        }
    }

    public static class WWindowImpl
    extends WLayoutedWidgetImpl<Stage, Pane, MWindow>
    implements WWindow<Stage> {
        private boolean support3d;
        private Pane rootPane;
        private BorderPane trimPane;
        private FillLayoutPane contentPane;
        private KeyBindingDispatcher dispatcher;
        private BorderPane decoratorPane;
        WindowResizeButton windowResizeButton;
        Stage stage;
        @Inject
        @Optional
        ThemeManager themeManager;
        private ThemeManager.Registration sceneRegistration;
        private String decorationFXML;
        private String rootFXML;
        private boolean fullscreen;
        @Inject
        @NonNull IEclipseContext context;
        IEclipseContext modelContext;
        @NonNull MWindow mWindow;
        @Inject
        TranslationService translationService;
        @Inject
        @NonNull BundleLocalization localizationService;
        @Inject
        @Optional
        WindowTransitionService<Stage> windowTransitionService;
        @Inject
        private GraphicsLoader graphicsLoader;
        @Inject
        private IEventBroker eventBroker;
        boolean initDone;
        private boolean undecorated;
        private StageStyle stageStyle;
        IEclipseContext applicationContext;
        private List<WWindow<Stage>> windows = new ArrayList<WWindow<Stage>>();
        WCallback<WWindow<Stage>, Boolean> onCloseCallback;
        private Boolean maximizedShell;
        List<WWidget<?>> lastActivationTree = new ArrayList();
        List<WWidget<?>> queuedTree = new ArrayList();
        private static final String KEY_SCENE_3D_DEPRECATED = "fx.scene.3d";
        private static final String KEY_SCENE_3D = "efx.window.scene.3d";
        private static final String KEY_STAGE_DECORATION_DEPRECATED = "fx.stage.decoration";
        private static final String KEY_STAGE_DECORATION = "efx.window.decoration.fxml";
        private static final String KEY_STAGE_STYLE = "efx.window.stagestyle";
        private static final String KEY_STAGE_UNDECORATED_DEPRECATED = "efx.window.undecorated";
        private static final String KEY_STAGE_ROOT_CONTENT = "efx.window.root.fxml";

        @Inject
        public WWindowImpl(@Named(value="fx.rendering.domElement") @NonNull MWindow mWindow, @Optional KeyBindingDispatcher dispatcher, MApplication application, @Log Logger logger) {
            this.mWindow = mWindow;
            this.applicationContext = application.getContext();
            if (mWindow.getPersistedState().get(KEY_SCENE_3D_DEPRECATED) != null) {
                logger.warning("Usage of deprecated persisted state 'fx.scene.3d' please use 'efx.window.scene.3d' instead.");
                this.support3d = Boolean.parseBoolean((String)mWindow.getPersistedState().get(KEY_SCENE_3D_DEPRECATED));
            } else {
                this.support3d = Boolean.parseBoolean((String)mWindow.getPersistedState().get(KEY_SCENE_3D));
            }
            this.dispatcher = dispatcher;
            this.modelContext = mWindow.getContext();
            this.decorationFXML = (String)mWindow.getPersistedState().get(KEY_STAGE_DECORATION_DEPRECATED);
            if (this.decorationFXML == null) {
                this.decorationFXML = (String)mWindow.getPersistedState().get(KEY_STAGE_DECORATION);
            } else {
                logger.warning("Useage of deprecated persisted state 'fx.stage.decoration' please use 'efx.window.decoration.fxml' instead.");
            }
            if (mWindow.getPersistedState().get(KEY_STAGE_STYLE) != null) {
                this.stageStyle = StageStyle.valueOf((String)((String)mWindow.getPersistedState().get(KEY_STAGE_STYLE)));
            } else if (mWindow.getPersistedState().get(KEY_STAGE_UNDECORATED_DEPRECATED) != null) {
                logger.warning("Usage of deprecated persisted state 'efx.window.undecorated' please use 'efx.window.stagestyle'");
                this.undecorated = Boolean.parseBoolean((String)mWindow.getPersistedState().get(KEY_STAGE_UNDECORATED_DEPRECATED));
            }
            if (mWindow.getTags().contains("shellMaximized")) {
                this.maximizedShell = Boolean.TRUE;
            }
            this.rootFXML = (String)mWindow.getPersistedState().get(KEY_STAGE_ROOT_CONTENT);
            if (this.decorationFXML != null && this.rootFXML != null) {
                logger.warning("You've specified a decorationXML and a rootFXML. Only rootFXML is used");
            }
        }

        @Override
        @PostConstruct
        protected void init() {
            this.initDone = true;
            super.init();
        }

        @Override
        protected void doCleanup() {
            super.doCleanup();
            this.sceneRegistration.dispose();
        }

        private static MWindow findParent(EObject tmp) {
            EObject e = tmp;
            if (e.eContainer() instanceof MApplication) {
                return null;
            }
            do {
                if (!((e = e.eContainer()) instanceof MWindow)) continue;
                return (MWindow)e;
            } while (e.eContainer() != null);
            return null;
        }

        @Override
        protected Stage createWidget() {
            Scene s;
            Stage stage;
            this.stage = stage = new Stage();
            MWindow parent = WWindowImpl.findParent((EObject)this.mWindow);
            if (parent != null) {
                this.stage.initOwner((Window)((WWindow)parent.getWidget()).getWidget());
            }
            this.stage.setOnCloseRequest(this::handleOnCloseRequest);
            this.stage.focusedProperty().addListener(this::handledFocus);
            if (this.maximizedShell != null) {
                this.stage.setMaximized(this.maximizedShell.booleanValue());
            }
            this.stage.setFullScreen(this.fullscreen);
            this.stage.fullScreenProperty().addListener(this::handleFullscreen);
            if (this.dispatcher != null) {
                this.stage.addEventFilter(KeyEvent.KEY_PRESSED, this.dispatcher.getKeyHandler());
            }
            this.trimPane = new BorderPane();
            this.trimPane.getStyleClass().add((Object)DefWindowRenderer.CSS_TRIM_CONTAINER);
            this.contentPane = new FillLayoutPane();
            this.contentPane.getStyleClass().add((Object)DefWindowRenderer.CSS_CONTENT_CONTAINER);
            this.trimPane.setCenter((Node)this.contentPane);
            if (this.rootFXML != null) {
                this.rootPane = this.createRootContainer(stage);
                ((CustomRootContainer)this.rootPane).setTrim((Node)this.trimPane);
            } else {
                BorderPane rootPane = new BorderPane(){

                    protected void layoutChildren() {
                        super.layoutChildren();
                        if (windowResizeButton != null) {
                            windowResizeButton.autosize();
                            windowResizeButton.setLayoutX(this.getWidth() - windowResizeButton.getLayoutBounds().getWidth());
                            windowResizeButton.setLayoutY(this.getHeight() - windowResizeButton.getLayoutBounds().getHeight());
                        }
                    }
                };
                this.rootPane = rootPane;
                rootPane.setCenter((Node)this.trimPane);
                if (this.decorationFXML != null) {
                    this.windowResizeButton = new WindowResizeButton(this.stage, 50.0, 50.0);
                    this.decoratorPane = new BorderPane();
                    this.decoratorPane.setTop(this.createTopDecoration(this.stage));
                    rootPane.setTop((Node)this.decoratorPane);
                }
            }
            if (this.stageStyle != null) {
                this.stage.initStyle(this.stageStyle);
            } else if (this.undecorated) {
                this.stage.initStyle(StageStyle.UNDECORATED);
            }
            if (this.support3d && Platform.isSupported((ConditionalFeature)ConditionalFeature.SCENE3D)) {
                s = new Scene((Parent)this.rootPane, (double)this.mWindow.getWidth(), (double)this.mWindow.getHeight(), true);
                s.setCamera((Camera)new PerspectiveCamera());
            } else {
                s = new Scene((Parent)this.rootPane, (double)this.mWindow.getWidth(), (double)this.mWindow.getHeight());
            }
            URL url = this.getClass().getClassLoader().getResource("css/efx-default.css");
            if (url != null) {
                s.getStylesheets().add((Object)url.toExternalForm());
            } else {
                this.logger.error("Unable to load css 'css/efx-default.css'");
            }
            s.focusOwnerProperty().addListener(this::handleFocusOwner);
            if (this.themeManager != null) {
                Theme theme = this.themeManager.getCurrentTheme();
                if (theme != null) {
                    ArrayList<String> sUrls = new ArrayList<String>();
                    for (URL url2 : theme.getStylesheetURL()) {
                        sUrls.add(url2.toExternalForm());
                    }
                    s.getStylesheets().addAll(sUrls);
                }
                this.sceneRegistration = this.themeManager.registerScene(s);
            }
            if (this.windowResizeButton != null) {
                this.rootPane.getChildren().add((Object)this.windowResizeButton);
            }
            this.stage.setScene(s);
            this.modelContext.set(Stage.class, (Object)this.stage);
            this.modelContext.set(Scene.class, (Object)s);
            return stage;
        }

        private void handleOnCloseRequest(WindowEvent event) {
            if (this.onCloseCallback != null && !Boolean.TRUE.equals(this.onCloseCallback.call((Object)this))) {
                event.consume();
            }
        }

        private void handleFullscreen(ObservableValue<? extends Boolean> obs, Boolean oldValue, Boolean newValue) {
            this.mWindow.getPersistedState().put("efx.window.fullscreen", newValue.toString());
        }

        private void handledFocus(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                this.activateWindow();
            }
        }

        private void activateWindow() {
            if (this.stage.getScene() != null) {
                this.applicationContext.set("efx_APP_FOCUS_NODE", (Object)this.stage.getScene().getFocusOwner());
            }
            if (!this.isActive()) {
                this.activate();
                this.eventBroker.send("org/eclipse/fx/MWindow/Activated", this.getDomElement());
            }
        }

        private void handleFocusOwner(ObservableValue<? extends Node> observable, Node oldValue, Node _newValue) {
            Node newValue = _newValue;
            this.modelContext.set("efx_WINDOW_FOCUS_NODE", (Object)newValue);
            if (this.stage.isFocused()) {
                this.applicationContext.set("efx_APP_FOCUS_NODE", (Object)newValue);
            }
            if (newValue != null) {
                final ArrayList activationTree = new ArrayList();
                do {
                    if (!(newValue.getUserData() instanceof WWidget)) continue;
                    activationTree.add((WWidget)newValue.getUserData());
                } while ((newValue = newValue.getParent()) != null);
                if (!this.lastActivationTree.equals(activationTree)) {
                    final ArrayList oldTreeReversed = new ArrayList(this.lastActivationTree);
                    final ArrayList newTreeReversed = new ArrayList(activationTree);
                    Collections.reverse(oldTreeReversed);
                    Collections.reverse(newTreeReversed);
                    Iterator it = newTreeReversed.iterator();
                    while (it.hasNext()) {
                        if (oldTreeReversed.isEmpty() || oldTreeReversed.get(0) != it.next()) break;
                        oldTreeReversed.remove(0);
                        it.remove();
                    }
                    Collections.reverse(oldTreeReversed);
                    Collections.reverse(newTreeReversed);
                    this.queuedTree = activationTree;
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (queuedTree == activationTree) {
                                lastActivationTree = activationTree;
                                for (WWidget w : oldTreeReversed) {
                                    w.deactivate();
                                }
                                for (WWidget w : newTreeReversed) {
                                    w.activate();
                                }
                            }
                        }
                    });
                }
            }
        }

        private Pane createRootContainer(Stage stage) {
            URI uri = URI.createURI((String)this.rootFXML);
            if (uri != null) {
                stage.initStyle(StageStyle.UNDECORATED);
                Bundle b = org.eclipse.core.runtime.Platform.getBundle((String)uri.segment(1));
                if (b != null) {
                    try {
                        StringBuilder sb = new StringBuilder();
                        int i = 2;
                        while (i < uri.segmentCount()) {
                            if (sb.length() != 0) {
                                sb.append("/");
                            }
                            sb.append(uri.segment(i));
                            ++i;
                        }
                        InjectingFXMLLoader loader = InjectingFXMLLoader.create((IEclipseContext)this.context, (Bundle)b, (String)sb.toString());
                        ResourceBundle resourceBundle = this.localizationService.getLocalization(b, Locale.getDefault().toString());
                        if (resourceBundle != null) {
                            loader.resourceBundle(resourceBundle);
                        }
                        return (Pane)loader.load();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return null;
        }

        private Node createTopDecoration(Stage stage) {
            URI uri = URI.createURI((String)this.decorationFXML);
            if (uri != null) {
                stage.initStyle(StageStyle.UNDECORATED);
                Bundle b = org.eclipse.core.runtime.Platform.getBundle((String)uri.segment(1));
                if (b != null) {
                    try {
                        StringBuilder sb = new StringBuilder();
                        int i = 2;
                        while (i < uri.segmentCount()) {
                            if (sb.length() != 0) {
                                sb.append("/");
                            }
                            sb.append(uri.segment(i));
                            ++i;
                        }
                        InjectingFXMLLoader loader = InjectingFXMLLoader.create((IEclipseContext)this.context, (Bundle)b, (String)sb.toString());
                        ResourceBundle resourceBundle = this.localizationService.getLocalization(b, Locale.getDefault().toString());
                        if (resourceBundle != null) {
                            loader.resourceBundle(resourceBundle);
                        }
                        return (Node)loader.load();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return null;
        }

        @Override
        protected void bindProperties(Stage widget) {
            super.bindProperties(widget);
            this.bindProperty("x", (ObservableValue<Object>)widget.xProperty());
            this.bindProperty("y", (ObservableValue<Object>)widget.yProperty());
            this.bindProperty("width", (ObservableValue<Object>)widget.widthProperty());
            this.bindProperty("height", (ObservableValue<Object>)widget.heightProperty());
        }

        public void setMainMenu(WLayoutedWidget<MMenu> menuWidget) {
            if (this.decoratorPane == null) {
                Node n = null;
                if (menuWidget != null) {
                    n = (Node)menuWidget.getStaticLayoutNode();
                }
                if (this.rootPane instanceof CustomRootContainer) {
                    ((CustomRootContainer)this.rootPane).setMenuBar(n);
                } else {
                    ((BorderPane)this.rootPane).setTop(n);
                }
            } else if (menuWidget == null) {
                this.decoratorPane.setBottom(null);
            } else {
                this.decoratorPane.setBottom((Node)menuWidget.getStaticLayoutNode());
            }
        }

        @Override
        protected Pane getWidgetNode() {
            return this.rootPane;
        }

        public void setOnCloseCallback(WCallback<WWindow<Stage>, Boolean> onCloseCallback) {
            this.onCloseCallback = onCloseCallback;
        }

        @Inject
        public void setX(@Named(value="x") int _x) {
            if (!this.isPropertyChangeInProgress("x")) {
                int x = _x;
                if (x == Integer.MIN_VALUE) {
                    x = 0;
                }
                ((Stage)this.getWidget()).setX((double)x);
            }
        }

        @Inject
        public void setY(@Named(value="y") int _y) {
            if (!this.isPropertyChangeInProgress("y")) {
                int y = _y;
                if (y == Integer.MIN_VALUE) {
                    y = 0;
                }
                ((Stage)this.getWidget()).setY((double)y);
            }
        }

        @Inject
        public void setWidth(@Named(value="width") int w) {
            if (!this.isPropertyChangeInProgress("width")) {
                ((Stage)this.getWidget()).setWidth((double)w);
            }
        }

        @Inject
        public void setHeight(@Named(value="height") int h) {
            if (!this.isPropertyChangeInProgress("height")) {
                ((Stage)this.getWidget()).setHeight((double)h);
            }
        }

        @Inject
        public void setVisible(@Named(value="visible") boolean visible) {
            if (!this.initDone) {
                return;
            }
            if (visible) {
                this.internalShow();
            } else {
                this.internalHide();
            }
        }

        @Inject
        public void setFullscreen(@Named(value="persistedState_efx.window.fullscreen") @Optional String fullScreen) {
            if (fullScreen != null) {
                this.fullscreen = Boolean.parseBoolean(fullScreen);
                if (this.stage != null) {
                    this.stage.setFullScreen(this.fullscreen);
                }
            } else {
                this.fullscreen = false;
            }
        }

        @Override
        public void addStyleClasses(List<String> classnames) {
            this.rootPane.getStyleClass().addAll(classnames);
        }

        @Override
        public void setStyleId(String id) {
            this.rootPane.setId(id);
        }

        public void show() {
            this.internalShow();
            ((Stage)this.getWidget()).toFront();
        }

        public void close() {
            ((Stage)this.getWidget()).close();
        }

        public void addChildWindow(WWindow<Stage> widget) {
            this.windows.add(widget);
            if (this.initDone && this.stage.isShowing()) {
                Stage s = (Stage)widget.getWidget();
                s.show();
            }
        }

        public void removeChildWindow(@NonNull WWindow<Stage> widget) {
            Stage s = (Stage)widget.getWidget();
            s.hide();
            this.windows.remove(widget);
        }

        private void internalShow() {
            if (((Stage)this.getWidget()).isShowing()) {
                return;
            }
            if (this.windowTransitionService != null) {
                WindowTransitionService.AnimationDelegate delegate = this.windowTransitionService.getShowDelegate(this.mWindow);
                if (delegate != null) {
                    delegate.animate((Object)((Stage)this.getWidget()), () -> {
                        this.activateWindow();
                        this.eventBroker.send("org/eclipse/fx/MWindow/Shown", (Object)this.mWindow);
                    });
                } else {
                    ((Stage)this.getWidget()).show();
                    this.activateWindow();
                    this.eventBroker.send("org/eclipse/fx/MWindow/Shown", (Object)this.mWindow);
                }
            } else {
                ((Stage)this.getWidget()).show();
                this.activateWindow();
                this.eventBroker.send("org/eclipse/fx/MWindow/Shown", (Object)this.mWindow);
            }
            for (WWindow<Stage> c : this.windows) {
                c.show();
                this.eventBroker.send("org/eclipse/fx/MWindow/Shown", (Object)this.mWindow);
            }
            if (this.windows.size() > 0) {
                this.stage.requestFocus();
                this.activateWindow();
            }
        }

        private void internalHide() {
            if (this.windowTransitionService != null) {
                WindowTransitionService.AnimationDelegate delegate = this.windowTransitionService.getShowDelegate(this.mWindow);
                if (delegate != null) {
                    delegate.animate((Object)((Stage)this.getWidget()), () -> this.eventBroker.send("org/eclipse/fx/MWindow/Hidden", (Object)this.mWindow));
                } else {
                    ((Stage)this.getWidget()).hide();
                    this.eventBroker.send("org/eclipse/fx/MWindow/Hidden", (Object)this.mWindow);
                }
            } else {
                ((Stage)this.getWidget()).hide();
                this.eventBroker.send("org/eclipse/fx/MWindow/Hidden", (Object)this.mWindow);
            }
        }

        @Inject
        public void setTitle(@Named(value="localizedLabel") String title) {
            ((Stage)this.getWidget()).setTitle(title);
            if (this.rootPane instanceof CustomRootContainer) {
                ((CustomRootContainer)this.rootPane).setTitle(title);
            }
        }

        @Inject
        public void setImageUrl(@Named(value="iconURI") @Optional String iconUri) {
            if (iconUri != null) {
                String[] split = iconUri.split(";");
                ArrayList<Image> images = new ArrayList<Image>();
                String[] stringArray = split;
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String uri = stringArray[n2];
                    Image img = this.graphicsLoader.getImage((org.eclipse.fx.core.URI)new EMFUri(URI.createURI((String)uri)));
                    if (img != null) {
                        images.add(img);
                    }
                    ++n2;
                }
                ((Stage)this.getWidget()).getIcons().setAll(images);
            } else {
                ((Stage)this.getWidget()).getIcons().clear();
            }
        }

        public void setBottomTrim(WLayoutedWidget<MTrimBar> trimBar) {
            if (trimBar == null) {
                this.trimPane.setBottom(null);
            } else {
                this.trimPane.setBottom((Node)trimBar.getStaticLayoutNode());
            }
        }

        public void setLeftTrim(WLayoutedWidget<MTrimBar> trimBar) {
            if (trimBar == null) {
                this.trimPane.setLeft(null);
            } else {
                this.trimPane.setLeft((Node)trimBar.getStaticLayoutNode());
            }
        }

        public void setRightTrim(WLayoutedWidget<MTrimBar> trimBar) {
            if (trimBar == null) {
                this.trimPane.setRight(null);
            } else {
                this.trimPane.setRight((Node)trimBar.getStaticLayoutNode());
            }
        }

        public void setTopTrim(WLayoutedWidget<MTrimBar> trimBar) {
            if (trimBar == null) {
                this.trimPane.setTop(null);
            } else {
                Node g = (Node)trimBar.getStaticLayoutNode();
                this.trimPane.setTop(g);
            }
        }

        public void addChild(WLayoutedWidget<MWindowElement> widget) {
            this.contentPane.getChildren().add((Object)((Node)widget.getStaticLayoutNode()));
        }

        public void removeChild(WLayoutedWidget<MWindowElement> widget) {
            this.contentPane.getChildren().remove((Object)((Node)widget.getStaticLayoutNode()));
        }

        public void addChild(int idx, WLayoutedWidget<MWindowElement> widget) {
            this.contentPane.getChildren().add(idx, (Object)((Node)widget.getStaticLayoutNode()));
        }
    }

    static class WindowResizeButton
    extends Region {
        double dragOffsetX;
        double dragOffsetY;
        final Stage stage;
        final double stageMinimumWidth;
        final double stageMinimumHeight;

        public WindowResizeButton(Stage stage, double stageMinimumWidth, double stageMinimumHeight) {
            this.stage = stage;
            this.stageMinimumWidth = stageMinimumWidth;
            this.stageMinimumHeight = stageMinimumHeight;
            this.setId("window-resize-button");
            this.setPrefSize(11.0, 11.0);
            this.setOnMousePressed(this::handleMousePressed);
            this.setOnMouseDragged(this::handleMouseDragged);
        }

        void handleMousePressed(MouseEvent e) {
            this.dragOffsetX = this.stage.getX() + this.stage.getWidth() - e.getScreenX();
            this.dragOffsetY = this.stage.getY() + this.stage.getHeight() - e.getScreenY();
            e.consume();
        }

        void handleMouseDragged(MouseEvent e) {
            ObservableList screens = Screen.getScreensForRectangle((double)this.stage.getX(), (double)this.stage.getY(), (double)1.0, (double)1.0);
            Screen screen = screens.size() > 0 ? (Screen)Screen.getScreensForRectangle((double)this.stage.getX(), (double)this.stage.getY(), (double)1.0, (double)1.0).get(0) : (Screen)Screen.getScreensForRectangle((double)0.0, (double)0.0, (double)1.0, (double)1.0).get(0);
            Rectangle2D visualBounds = screen.getVisualBounds();
            double maxX = Math.min(visualBounds.getMaxX(), e.getScreenX() + this.dragOffsetX);
            double maxY = Math.min(visualBounds.getMaxY(), e.getScreenY() - this.dragOffsetY);
            this.stage.setWidth(Math.max(this.stageMinimumWidth, maxX - this.stage.getX()));
            this.stage.setHeight(Math.max(this.stageMinimumHeight, maxY - this.stage.getY()));
            e.consume();
        }
    }
}

