/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.nls;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.eclipse.e4.core.internal.services.ServicesActivator;
import org.eclipse.e4.core.services.nls.MessageConsumer;
import org.eclipse.e4.core.services.nls.MessageFunction;
import org.eclipse.e4.core.services.nls.MessageSupplier;
import org.osgi.service.log.LogService;

public class BaseMessageRegistry<M> {
    private static LogService logService = ServicesActivator.getDefault().getLogService();
    private M messages;
    private final Map<MessageConsumer, MessageSupplier> bindings = new HashMap<MessageConsumer, MessageSupplier>();

    public void register(MessageConsumer consumer, final MessageFunction<M> function) {
        this.register(consumer, new MessageSupplier(){

            @Override
            public String get() {
                return function.apply(BaseMessageRegistry.this.messages);
            }
        });
    }

    public void register(MessageConsumer consumer, MessageSupplier supplier) {
        consumer.accept(supplier.get());
        this.bindings.put(consumer, supplier);
    }

    public void register(Object control, String method, String messageKey) {
        MessageConsumer consumer = this.createConsumer(control, method);
        MessageSupplier supplier = this.createSupplier(messageKey);
        if (consumer != null && supplier != null) {
            this.register(consumer, supplier);
        }
    }

    public void registerProperty(Object control, String property, String messageKey) {
        MessageConsumer consumer = this.createConsumer(control, "set" + Character.toUpperCase(property.charAt(0)) + property.substring(1));
        MessageSupplier supplier = this.createSupplier(messageKey);
        if (consumer != null && supplier != null) {
            this.register(consumer, supplier);
        }
    }

    public void updateMessages(M messages) {
        this.messages = messages;
        for (Map.Entry<MessageConsumer, MessageSupplier> entry : this.bindings.entrySet()) {
            entry.getKey().accept(entry.getValue().get());
        }
    }

    protected MessageConsumer createConsumer(final Object control, String method) {
        MessageConsumer consumer;
        block5: {
            consumer = null;
            try {
                final Method m = control.getClass().getMethod(method, String.class);
                if (m != null) {
                    consumer = new MessageConsumer(){

                        @Override
                        public void accept(final String value) {
                            block4: {
                                try {
                                    if (System.getSecurityManager() == null) {
                                        m.setAccessible(true);
                                        m.invoke(control, value);
                                    } else {
                                        AccessController.doPrivileged(new PrivilegedAction(){

                                            public Object run() {
                                                block2: {
                                                    m.setAccessible(true);
                                                    try {
                                                        m.invoke(control, value);
                                                    }
                                                    catch (Exception e) {
                                                        BaseMessageRegistry.this.bindings.remove(this);
                                                        if (logService == null) break block2;
                                                        logService.log(3, "Error on invoke '" + m.getName() + "' on '" + control.getClass() + "' with error message '" + e.getMessage() + "'. Binding is removed.");
                                                    }
                                                }
                                                return null;
                                            }
                                        });
                                    }
                                }
                                catch (Exception e) {
                                    BaseMessageRegistry.this.bindings.remove(this);
                                    if (logService == null) break block4;
                                    logService.log(3, "Error on invoke '" + m.getName() + "' on '" + control.getClass() + "' with error message '" + e.getMessage() + "'. Binding is removed.");
                                }
                            }
                        }
                    };
                }
            }
            catch (NoSuchMethodException e) {
                if (logService != null) {
                    logService.log(2, "The method '" + e.getMessage() + "' does not exist. Binding is not created!");
                }
            }
            catch (SecurityException e) {
                if (logService == null) break block5;
                logService.log(2, "Error on accessing method '" + method + "' on class '" + control.getClass() + "' with error message '" + e.getMessage() + "'. Binding is not created!");
            }
        }
        return consumer;
    }

    protected MessageSupplier createSupplier(String messageKey) {
        MessageSupplier supplier;
        block5: {
            supplier = null;
            try {
                final Field f = this.messages.getClass().getField(messageKey);
                if (f != null) {
                    supplier = new MessageSupplier(){

                        @Override
                        public String get() {
                            String message;
                            block2: {
                                message = null;
                                try {
                                    message = (String)f.get(BaseMessageRegistry.this.messages);
                                }
                                catch (Exception e) {
                                    BaseMessageRegistry.this.bindings.remove(this);
                                    if (logService == null) break block2;
                                    logService.log(3, "Error on invoke '" + f.getName() + "' on '" + BaseMessageRegistry.this.messages.getClass() + "' with error message '" + e.getMessage() + "'. Binding is removed.");
                                }
                            }
                            return message;
                        }
                    };
                }
            }
            catch (NoSuchFieldException e) {
                if (logService != null) {
                    logService.log(2, "The class '" + this.messages.getClass().getName() + "' does not contain a field with name '" + e.getMessage() + "'. Binding is not created!");
                }
            }
            catch (SecurityException e) {
                if (logService == null) break block5;
                logService.log(2, "Error on accessing field '" + messageKey + "' on class '" + this.messages.getClass() + "' with error message '" + e.getMessage() + "'. Binding is not created!");
            }
        }
        return supplier;
    }

    @PreDestroy
    void unregister() {
        this.bindings.clear();
    }
}

