/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.di.context.internal;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.fx.core.Callback;
import org.eclipse.fx.core.adapter.AdapterProvider;
import org.eclipse.fx.core.adapter.AdapterService;
import org.eclipse.fx.core.di.ContextBoundValue;

public class ObservableAdapterProvider
implements AdapterProvider<ContextBoundValue, IObservableValue> {
    public Class<ContextBoundValue> getSourceType() {
        return ContextBoundValue.class;
    }

    public Class<IObservableValue> getTargetType() {
        return IObservableValue.class;
    }

    public boolean canAdapt(ContextBoundValue sourceObject, Class<IObservableValue> targetType) {
        return true;
    }

    public IObservableValue adapt(final ContextBoundValue sourceObject, Class<IObservableValue> targetType, AdapterService.ValueAccess ... valueAccess) {
        Realm r = null;
        AdapterService.ValueAccess[] valueAccessArray = valueAccess;
        int n = valueAccess.length;
        int n2 = 0;
        while (n2 < n) {
            AdapterService.ValueAccess a = valueAccessArray[n2];
            r = (Realm)a.getValue(Realm.class);
            if (r != null) break;
            ++n2;
        }
        if (r == null) {
            r = Realm.getDefault();
        }
        if (r == null) {
            r = new Realm(){
                private Thread t = Thread.currentThread();

                public boolean isCurrent() {
                    return this.t == Thread.currentThread();
                }
            };
        }
        final WritableValue w = new WritableValue(r);
        w.setValue(sourceObject.getValue());
        w.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                sourceObject.publish(event.diff.getNewValue());
            }
        });
        sourceObject.subscribeOnValueChange(new Callback(){

            public void call(Object value) {
                w.setValue(value);
            }
        });
        sourceObject.subscribeOnDispose((Callback)new Callback<Void>(){

            public void call(Void value) {
                w.dispose();
            }
        });
        return w;
    }
}

