/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.tukaani.xz.BlockInputStream;
import org.tukaani.xz.CorruptedInputException;
import org.tukaani.xz.IndexIndicatorException;
import org.tukaani.xz.MemoryLimitException;
import org.tukaani.xz.SeekableInputStream;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.XZ;
import org.tukaani.xz.XZFormatException;
import org.tukaani.xz.XZIOException;
import org.tukaani.xz.check.Check;
import org.tukaani.xz.common.DecoderUtil;
import org.tukaani.xz.common.StreamFlags;
import org.tukaani.xz.index.BlockInfo;
import org.tukaani.xz.index.IndexDecoder;

public class SeekableXZInputStream
extends SeekableInputStream {
    private SeekableInputStream in;
    private final int memoryLimit;
    private int indexMemoryUsage = 0;
    private final ArrayList streams = new ArrayList();
    private int checkTypes = 0;
    private long uncompressedSize = 0L;
    private long largestBlockSize = 0L;
    private int blockCount = 0;
    private final BlockInfo curBlockInfo;
    private final BlockInfo queriedBlockInfo;
    private Check check;
    private BlockInputStream blockDecoder = null;
    private long curPos = 0L;
    private long seekPos;
    private boolean seekNeeded = false;
    private boolean endReached = false;
    private IOException exception = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SeekableXZInputStream(SeekableInputStream seekableInputStream) throws IOException {
        this(seekableInputStream, -1);
    }

    public SeekableXZInputStream(SeekableInputStream seekableInputStream, int n) throws IOException {
        Object object;
        this.in = seekableInputStream;
        DataInputStream dataInputStream = new DataInputStream(seekableInputStream);
        seekableInputStream.seek(0L);
        byte[] byArray = new byte[XZ.HEADER_MAGIC.length];
        dataInputStream.readFully(byArray);
        if (!Arrays.equals(byArray, XZ.HEADER_MAGIC)) {
            throw new XZFormatException();
        }
        long l = seekableInputStream.length();
        if ((l & 3L) != 0L) {
            throw new CorruptedInputException("XZ file size is not a multiple of 4 bytes");
        }
        byte[] byArray2 = new byte[12];
        long l2 = 0L;
        while (l > 0L) {
            long l3;
            IndexDecoder indexDecoder;
            if (l < 12L) {
                throw new CorruptedInputException();
            }
            seekableInputStream.seek(l - 12L);
            dataInputStream.readFully(byArray2);
            if (byArray2[8] == 0 && byArray2[9] == 0 && byArray2[10] == 0 && byArray2[11] == 0) {
                l2 += 4L;
                l -= 4L;
                continue;
            }
            object = DecoderUtil.decodeStreamFooter(byArray2);
            if (((StreamFlags)object).backwardSize >= (l -= 12L)) {
                throw new CorruptedInputException("Backward Size in XZ Stream Footer is too big");
            }
            this.check = Check.getInstance(((StreamFlags)object).checkType);
            this.checkTypes |= 1 << ((StreamFlags)object).checkType;
            seekableInputStream.seek(l - ((StreamFlags)object).backwardSize);
            try {
                indexDecoder = new IndexDecoder(seekableInputStream, (StreamFlags)object, l2, n);
            }
            catch (MemoryLimitException memoryLimitException) {
                if (!$assertionsDisabled && n < 0) {
                    throw new AssertionError();
                }
                throw new MemoryLimitException(memoryLimitException.getMemoryNeeded() + this.indexMemoryUsage, n + this.indexMemoryUsage);
            }
            this.indexMemoryUsage += indexDecoder.getMemoryUsage();
            if (n >= 0 && !$assertionsDisabled && (n -= indexDecoder.getMemoryUsage()) < 0) {
                throw new AssertionError();
            }
            if (this.largestBlockSize < indexDecoder.getLargestBlockSize()) {
                this.largestBlockSize = indexDecoder.getLargestBlockSize();
            }
            if (l < (l3 = indexDecoder.getStreamSize() - 12L)) {
                throw new CorruptedInputException("XZ Index indicates too big compressed size for the XZ Stream");
            }
            seekableInputStream.seek(l -= l3);
            dataInputStream.readFully(byArray2);
            StreamFlags streamFlags = DecoderUtil.decodeStreamHeader(byArray2);
            if (!DecoderUtil.areStreamFlagsEqual(streamFlags, (StreamFlags)object)) {
                throw new CorruptedInputException("XZ Stream Footer does not match Stream Header");
            }
            this.uncompressedSize += indexDecoder.getUncompressedSize();
            if (this.uncompressedSize < 0L) {
                throw new UnsupportedOptionsException("XZ file is too big");
            }
            this.blockCount += indexDecoder.getRecordCount();
            if (this.blockCount < 0) {
                throw new UnsupportedOptionsException("XZ file has over 2147483647 Blocks");
            }
            this.streams.add(indexDecoder);
            l2 = 0L;
        }
        if (!$assertionsDisabled && l != 0L) {
            throw new AssertionError();
        }
        this.memoryLimit = n;
        object = (IndexDecoder)this.streams.get(this.streams.size() - 1);
        for (int i = this.streams.size() - 2; i >= 0; --i) {
            IndexDecoder indexDecoder = (IndexDecoder)this.streams.get(i);
            indexDecoder.setOffsets((IndexDecoder)object);
            object = indexDecoder;
        }
        IndexDecoder indexDecoder = (IndexDecoder)this.streams.get(this.streams.size() - 1);
        this.curBlockInfo = new BlockInfo(indexDecoder);
        this.queriedBlockInfo = new BlockInfo(indexDecoder);
    }

    public int getCheckTypes() {
        return this.checkTypes;
    }

    public int getIndexMemoryUsage() {
        return this.indexMemoryUsage;
    }

    public long getLargestBlockSize() {
        return this.largestBlockSize;
    }

    public int getStreamCount() {
        return this.streams.size();
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public long getBlockPos(int n) {
        this.locateBlockByNumber(this.queriedBlockInfo, n);
        return this.queriedBlockInfo.uncompressedOffset;
    }

    public long getBlockSize(int n) {
        this.locateBlockByNumber(this.queriedBlockInfo, n);
        return this.queriedBlockInfo.uncompressedSize;
    }

    public long getBlockCompPos(int n) {
        this.locateBlockByNumber(this.queriedBlockInfo, n);
        return this.queriedBlockInfo.compressedOffset;
    }

    public long getBlockCompSize(int n) {
        this.locateBlockByNumber(this.queriedBlockInfo, n);
        return this.queriedBlockInfo.unpaddedSize + 3L & 0xFFFFFFFFFFFFFFFCL;
    }

    public int getBlockCheckType(int n) {
        this.locateBlockByNumber(this.queriedBlockInfo, n);
        return this.queriedBlockInfo.getCheckType();
    }

    public int getBlockNumber(long l) {
        this.locateBlockByPos(this.queriedBlockInfo, l);
        return this.queriedBlockInfo.blockNumber;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        return this.read(byArray, 0, 1) == -1 ? -1 : byArray[0] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        block13: {
            if (n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.in == null) {
                throw new XZIOException("Stream closed");
            }
            if (this.exception != null) {
                throw this.exception;
            }
            n3 = 0;
            try {
                if (this.seekNeeded) {
                    this.seek();
                }
                if (this.endReached) {
                    return -1;
                }
                while (n2 > 0) {
                    int n4;
                    if (this.blockDecoder == null) {
                        this.seek();
                        if (this.endReached) break;
                    }
                    if ((n4 = this.blockDecoder.read(byArray, n, n2)) > 0) {
                        this.curPos += (long)n4;
                        n3 += n4;
                        n += n4;
                        n2 -= n4;
                        continue;
                    }
                    if (n4 != -1) continue;
                    this.blockDecoder = null;
                }
            }
            catch (IOException iOException) {
                CorruptedInputException corruptedInputException;
                if (iOException instanceof EOFException) {
                    corruptedInputException = new CorruptedInputException();
                }
                this.exception = corruptedInputException;
                if (n3 != 0) break block13;
                throw corruptedInputException;
            }
        }
        return n3;
    }

    public int available() throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.endReached || this.seekNeeded || this.blockDecoder == null) {
            return 0;
        }
        return this.blockDecoder.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
    }

    public long length() {
        return this.uncompressedSize;
    }

    public long position() throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        return this.seekNeeded ? this.seekPos : this.curPos;
    }

    public void seek(long l) throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (l < 0L) {
            throw new XZIOException("Negative seek position: " + l);
        }
        this.seekPos = l;
        this.seekNeeded = true;
    }

    public void seekToBlock(int n) throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (n < 0 || n >= this.blockCount) {
            throw new XZIOException("Invalid XZ Block number: " + n);
        }
        this.seekPos = this.getBlockPos(n);
        this.seekNeeded = true;
    }

    private void seek() throws IOException {
        if (!this.seekNeeded) {
            if (this.curBlockInfo.hasNext()) {
                this.curBlockInfo.setNext();
                this.initBlockDecoder();
                return;
            }
            this.seekPos = this.curPos;
        }
        this.seekNeeded = false;
        if (this.seekPos >= this.uncompressedSize) {
            this.curPos = this.seekPos;
            this.blockDecoder = null;
            this.endReached = true;
            return;
        }
        this.endReached = false;
        this.locateBlockByPos(this.curBlockInfo, this.seekPos);
        if (this.curPos <= this.curBlockInfo.uncompressedOffset || this.curPos > this.seekPos) {
            this.in.seek(this.curBlockInfo.compressedOffset);
            this.check = Check.getInstance(this.curBlockInfo.getCheckType());
            this.initBlockDecoder();
            this.curPos = this.curBlockInfo.uncompressedOffset;
        }
        if (this.seekPos > this.curPos) {
            long l = this.seekPos - this.curPos;
            if (this.blockDecoder.skip(l) != l) {
                throw new CorruptedInputException();
            }
            this.curPos = this.seekPos;
        }
    }

    private void locateBlockByPos(BlockInfo blockInfo, long l) {
        IndexDecoder indexDecoder;
        if (l < 0L || l >= this.uncompressedSize) {
            throw new IndexOutOfBoundsException("Invalid uncompressed position: " + l);
        }
        int n = 0;
        while (!(indexDecoder = (IndexDecoder)this.streams.get(n)).hasUncompressedOffset(l)) {
            ++n;
        }
        indexDecoder.locateBlock(blockInfo, l);
        if (!$assertionsDisabled && (blockInfo.compressedOffset & 3L) != 0L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && blockInfo.uncompressedSize <= 0L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && l < blockInfo.uncompressedOffset) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && l >= blockInfo.uncompressedOffset + blockInfo.uncompressedSize) {
            throw new AssertionError();
        }
    }

    private void locateBlockByNumber(BlockInfo blockInfo, int n) {
        if (n < 0 || n >= this.blockCount) {
            throw new IndexOutOfBoundsException("Invalid XZ Block number: " + n);
        }
        if (blockInfo.blockNumber == n) {
            return;
        }
        int n2 = 0;
        while (true) {
            IndexDecoder indexDecoder;
            if ((indexDecoder = (IndexDecoder)this.streams.get(n2)).hasRecord(n)) {
                indexDecoder.setBlockInfo(blockInfo, n);
                return;
            }
            ++n2;
        }
    }

    private void initBlockDecoder() throws IOException {
        try {
            this.blockDecoder = null;
            this.blockDecoder = new BlockInputStream(this.in, this.check, this.memoryLimit, this.curBlockInfo.unpaddedSize, this.curBlockInfo.uncompressedSize);
        }
        catch (MemoryLimitException memoryLimitException) {
            if (!$assertionsDisabled && this.memoryLimit < 0) {
                throw new AssertionError();
            }
            throw new MemoryLimitException(memoryLimitException.getMemoryNeeded() + this.indexMemoryUsage, this.memoryLimit + this.indexMemoryUsage);
        }
        catch (IndexIndicatorException indexIndicatorException) {
            throw new CorruptedInputException();
        }
    }

    static {
        $assertionsDisabled = !SeekableXZInputStream.class.desiredAssertionStatus();
    }
}

