/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.reflect;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IMirror;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.impl.AbstractRuntimeJvmTypeProvider;
import org.eclipse.xtext.common.types.access.impl.ClassFinder;
import org.eclipse.xtext.common.types.access.impl.ClassMirror;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.common.types.access.impl.TypeResourceServices;
import org.eclipse.xtext.common.types.access.reflect.ReflectURIHelper;
import org.eclipse.xtext.common.types.access.reflect.ReflectionTypeFactory;
import org.eclipse.xtext.util.Strings;

public class ReflectionTypeProvider
extends AbstractRuntimeJvmTypeProvider {
    private final ClassFinder classFinder;
    private final ReflectionTypeFactory reflectionTypeFactory;
    private final ReflectURIHelper uriHelper;

    @Deprecated
    public ReflectionTypeProvider(ClassLoader classLoader, ResourceSet resourceSet, IndexedJvmTypeAccess indexedJvmTypeAccess) {
        this(classLoader, resourceSet, indexedJvmTypeAccess, null);
    }

    public ReflectionTypeProvider(ClassLoader classLoader, ResourceSet resourceSet, IndexedJvmTypeAccess indexedJvmTypeAccess, TypeResourceServices services) {
        super(resourceSet, indexedJvmTypeAccess, services);
        this.classFinder = this.createClassFinder(classLoader);
        this.uriHelper = this.createClassURIHelper();
        this.reflectionTypeFactory = this.createDeclaredTypeFactory();
    }

    @Deprecated
    public ReflectionTypeProvider(ClassLoader classLoader, ResourceSet resourceSet) {
        this(classLoader, resourceSet, null);
    }

    protected ClassFinder createClassFinder(ClassLoader classLoader) {
        return new ClassFinder(classLoader);
    }

    protected ReflectionTypeFactory createDeclaredTypeFactory() {
        return new ReflectionTypeFactory(this.uriHelper);
    }

    protected ReflectURIHelper createClassURIHelper() {
        return new ReflectURIHelper();
    }

    public ReflectURIHelper getClassURIHelper() {
        return this.uriHelper;
    }

    public ReflectionTypeFactory getDeclaredTypeFactory() {
        return this.reflectionTypeFactory;
    }

    public ClassFinder getClassFinder() {
        return this.classFinder;
    }

    @Override
    public JvmType findTypeByName(String name) {
        try {
            Class clazz = (Class)this.classFinder.forName(name);
            return this.findTypeByClass(clazz);
        }
        catch (ClassNotFoundException e) {
            return this.tryFindTypeInIndex(name, true);
        }
        catch (NoClassDefFoundError e) {
            return this.tryFindTypeInIndex(name, true);
        }
    }

    @Override
    public JvmType findTypeByName(String name, boolean binaryNestedTypeDelimiter) {
        if (this.isBinaryNestedTypeDelimiter(name, binaryNestedTypeDelimiter)) {
            return this.findTypeByName(name);
        }
        return this.doFindTypeByName(name);
    }

    private JvmType doFindTypeByName(String name) {
        try {
            Class<?> clazz = this.findClassByName(name);
            return this.findTypeByClass(clazz);
        }
        catch (AbstractRuntimeJvmTypeProvider.ClassNotFoundExceptionWithBaseName e) {
            String outerName = e.getBaseName();
            JvmType outer = this.doFindTypeByName(outerName);
            if (outer instanceof JvmDeclaredType) {
                String nestedNames = name.substring(outerName.length() + 1);
                List segments = Strings.split((String)nestedNames, (String)".");
                return this.findNestedType((JvmDeclaredType)outer, segments, 0);
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            return this.tryFindTypeInIndex(name, false);
        }
        catch (NoClassDefFoundError e) {
            return this.tryFindTypeInIndex(name, false);
        }
    }

    private JvmType findTypeByClass(Class<?> clazz) {
        URI proxyURI;
        EObject candidate;
        IndexedJvmTypeAccess indexedJvmTypeAccess = this.getIndexedJvmTypeAccess();
        URI resourceURI = this.uriHelper.createResourceURI(clazz);
        if (indexedJvmTypeAccess != null && (candidate = indexedJvmTypeAccess.getIndexedJvmType(proxyURI = resourceURI.appendFragment(this.uriHelper.getFragment(clazz)), this.getResourceSet())) instanceof JvmType) {
            return (JvmType)candidate;
        }
        TypeResource result = (TypeResource)this.getResourceSet().getResource(resourceURI, true);
        return this.findTypeByClass(clazz, (Resource)result);
    }

    private Class<?> findClassByName(String name) throws ClassNotFoundException {
        try {
            Class clazz = (Class)this.classFinder.forName(name);
            return clazz;
        }
        catch (ClassNotFoundException exception) {
            int index = name.lastIndexOf(46);
            if (index <= 0) {
                throw exception;
            }
            String baseName = name.substring(0, index);
            try {
                Class<?> resolvedOuterClass = this.findClassByName(baseName);
                baseName = resolvedOuterClass.getName();
            }
            catch (ClassNotFoundException baseNameException) {
                throw exception;
            }
            String validBaseName = baseName;
            try {
                String binaryName = String.valueOf(baseName) + '$' + name.substring(index + 1);
                Class clazz = (Class)this.classFinder.forName(binaryName);
                return clazz;
            }
            catch (ClassNotFoundException e) {
                throw new AbstractRuntimeJvmTypeProvider.ClassNotFoundExceptionWithBaseName(validBaseName);
            }
        }
    }

    protected JvmType tryFindTypeInIndex(String name, boolean binaryNestedTypeDelimiter) {
        AbstractRuntimeJvmTypeProvider.TypeInResourceSetAdapter adapter = (AbstractRuntimeJvmTypeProvider.TypeInResourceSetAdapter)EcoreUtil.getAdapter((List)this.getResourceSet().eAdapters(), AbstractRuntimeJvmTypeProvider.TypeInResourceSetAdapter.class);
        if (adapter != null) {
            return adapter.tryFindTypeInIndex(name, this, binaryNestedTypeDelimiter);
        }
        return this.doTryFindInIndex(name, binaryNestedTypeDelimiter);
    }

    @Override
    protected IMirror createMirrorForFQN(String name) {
        try {
            Class clazz = (Class)this.classFinder.forName(name);
            return this.createMirror(clazz);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public ClassMirror createMirror(Class<?> clazz) {
        return ClassMirror.createClassMirror(clazz, this.reflectionTypeFactory);
    }

    public JvmType findTypeByClass(Class<?> clazz, Resource resource) {
        String fragment = this.uriHelper.getFragment(clazz);
        JvmType result = (JvmType)resource.getEObject(fragment);
        if (result == null) {
            throw new IllegalStateException("Resource has not been loaded");
        }
        return result;
    }
}

