/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.BoundingBox;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Window;
import javafx.util.Duration;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.ui.controls.styledtext.StyledString;
import org.eclipse.fx.ui.controls.styledtext.StyledStringSegment;

public class Util {
    public static final String FIND_NODE_EXCLUDE = "findNodeExclude";

    public static String dumpSceneGraph(Node n) {
        return new SceneGraphDumper().dump(n).toString();
    }

    public static Node toNode(StyledString s) {
        ArrayList<Text> segList = new ArrayList<Text>();
        for (StyledStringSegment seg : s.getSegmentList()) {
            Text t = new Text(seg.getText());
            t.getStyleClass().addAll(seg.getStyleClass());
            segList.add(t);
        }
        return new TextFlow(segList.toArray(new Node[0]));
    }

    public static Node findNode(Window w, double screenX, double screenY) {
        if (new BoundingBox(w.getX(), w.getY(), w.getWidth(), w.getHeight()).contains(screenX, screenY)) {
            return Util.findNode((Node)w.getScene().getRoot(), screenX, screenY);
        }
        Iterator impl_getWindows = Window.impl_getWindows();
        while (impl_getWindows.hasNext()) {
            Window window = (Window)impl_getWindows.next();
            if (FIND_NODE_EXCLUDE.equals(window.getUserData()) || !new BoundingBox(window.getX(), window.getY(), window.getWidth(), window.getHeight()).contains(screenX, screenY)) continue;
            return Util.findNode((Node)window.getScene().getRoot(), screenX, screenY);
        }
        return null;
    }

    public static Node findNode(Node n, double screenX, double screenY) {
        Node rv = null;
        if (!n.isVisible()) {
            return rv;
        }
        Point2D b = n.screenToLocal(screenX, screenY);
        if (n.getBoundsInLocal().contains(b)) {
            rv = n;
            if (n instanceof Parent) {
                for (Node c : ((Parent)n).getChildrenUnmodifiable()) {
                    Node cn = Util.findNode(c, screenX, screenY);
                    if (cn == null) continue;
                    rv = cn;
                    break;
                }
            }
        }
        return rv;
    }

    public static ObservableValue<Window> windowProperty(Node n) {
        SimpleObjectProperty w = new SimpleObjectProperty();
        ChangeListener l = (arg_0, arg_1, arg_2) -> Util.lambda$0((ObjectProperty)w, arg_0, arg_1, arg_2);
        n.sceneProperty().addListener((o, oldV, newV) -> {
            if (oldV != null) {
                oldV.windowProperty().removeListener(l);
            }
            if (newV != null) {
                newV.windowProperty().addListener(l);
            }
        });
        return w;
    }

    public static <T, E> Subscription bindContent(List<? extends T> target, final ObservableList<E> sourceList, Function<E, T> converterFunction) {
        List list = sourceList.stream().map(converterFunction).collect(Collectors.toList());
        if (target instanceof ObservableList) {
            ((ObservableList)target).setAll(list);
        } else {
            target.clear();
            target.addAll(list);
        }
        final ListChangeListener l = change -> {
            while (change.next()) {
                if (change.wasPermutated()) {
                    list.subList(change.getFrom(), change.getTo()).clear();
                    list.addAll(change.getFrom(), Util.transformList(change.getList().subList(change.getFrom(), change.getTo()), converterFunction));
                    continue;
                }
                if (change.wasRemoved()) {
                    list.subList(change.getFrom(), change.getFrom() + change.getRemovedSize()).clear();
                }
                if (!change.wasAdded()) continue;
                list.addAll(change.getFrom(), Util.transformList(change.getAddedSubList(), converterFunction));
            }
        };
        sourceList.addListener(l);
        return new Subscription(){

            public void dispose() {
                sourceList.removeListener(l);
            }
        };
    }

    public static <T, E> List<T> transformList(List<? extends E> list, Function<E, T> converterFunction) {
        return list.stream().map(converterFunction).collect(Collectors.toList());
    }

    public static Subscription installHoverCallback(Node node, Duration delay, Consumer<MouseEvent> hoverConsumer) {
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(delay, new KeyValue[0])});
        AtomicReference event = new AtomicReference();
        t.setOnFinished(e -> {
            if (event.get() != null) {
                hoverConsumer.accept((MouseEvent)event.get());
            }
        });
        EventHandler moveHandler = e -> {
            event.set(e);
            t.stop();
            t.playFromStart();
        };
        EventHandler exitHandler = e -> t.stop();
        node.addEventHandler(MouseEvent.MOUSE_MOVED, moveHandler);
        node.addEventHandler(MouseEvent.MOUSE_EXITED, exitHandler);
        return () -> {
            node.removeEventHandler(MouseEvent.MOUSE_MOVED, moveHandler);
            node.removeEventHandler(MouseEvent.MOUSE_EXITED, exitHandler);
        };
    }

    private static /* synthetic */ void lambda$0(ObjectProperty objectProperty, ObservableValue o, Window oldV, Window newV) {
        objectProperty.set((Object)newV);
    }

    static class SceneGraphDumper {
        private StringBuilder sb = new StringBuilder();
        private int ident = 0;

        SceneGraphDumper() {
        }

        public StringBuilder dump(Node n) {
            int i = 0;
            while (i < this.ident) {
                this.sb.append("    ");
                ++i;
            }
            ++this.ident;
            this.sb.append("<" + n.getClass().getName() + " styleClass=\"" + n.getStyleClass() + "\">\n");
            if (n instanceof Parent) {
                for (Node subNode : ((Parent)n).getChildrenUnmodifiable()) {
                    this.dump(subNode);
                }
            }
            --this.ident;
            i = 0;
            while (i < this.ident) {
                this.sb.append("    ");
                ++i;
            }
            this.sb.append("</" + n.getClass().getName() + ">\n");
            return this.sb;
        }
    }
}

